//////////////////////////////////////////////////////////////////////
// Sound.h: interface for the CSound class.
//
//////////////////////////////////////////////////////////////////////
// Copyright 2000.    Moe Wheatley AE4JY  <ae4jy@mindspring.com>
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
////////////////////////////////////////////////////////////////////////

#if !defined(AFX_SOUND_H__0A83B9C2_549A_11D2_A141_00A0C996E7F5__INCLUDED_)
#define AFX_SOUND_H__0A83B9C2_549A_11D2_A141_00A0C996E7F5__INCLUDED_

#include <mmsystem.h>

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000


#define NUM_INPUT_SNDBUFFERS 3		// number of sound input buffers to allocate
#define NUM_OUTPUT_SNDBUFFERS 3		// number of sound output buffers to allocate

//+++++++++++++   WAVEFORMATEX  member variables     +++++++++++++++++++
//typedef struct { 
//    WORD  wFormatTag; 
//    WORD  nChannels; 
//    DWORD nSamplesPerSec; 
//    DWORD nAvgBytesPerSec; 
//    WORD  nBlockAlign; 
//    WORD  wBitsPerSample; 
//    WORD  cbSize; 
//} WAVEFORMATEX; 

class CSound  
{
public:
	CSound();
	virtual ~CSound();
	// Public member functions for object's users.
	UINT InOpen( WAVEFORMATEX* pWFX, DWORD BufSize, DWORD SampleLimit, INT card);
	LONG InRead( double* pData, INT Length );
	void InClose();
	UINT OutOpen( WAVEFORMATEX* pWFX, DWORD BufSize, DWORD SampleLimit, INT card);
	LONG OutWrite( double* pData, INT Length);
	void OutClose();
	UINT GetError(void){return m_ErrorCode;}

	// Public variables for use by callback functions only.
	HANDLE m_InEventHandle;
	HANDLE m_OutEventHandle;
	BOOL m_InWaiting;
	BOOL m_InOverflow;
	BOOL m_OutWaiting;
	BOOL m_OutUnderflow;
	INT	m_InHeadPtr;
	INT m_InTailPtr;
	INT	m_OutHeadPtr;
	INT m_OutTailPtr;
	CRITICAL_SECTION m_CriticalSection;	// use for keeping threads
										// from stomping on each other

private:
	UINT WaitForFlush();
	BOOL m_InputOpen;
	BOOL m_OutputOpen;
	BOOL m_fOutputHoldoff;		//keeps output off until half the buffers are full
	INT m_InBytesTotal;
	INT m_InBytesPerSample;
	INT m_OutBytesPerSample;
	UINT m_ErrorCode;
	LONG m_InBufferSize;		//bytes in each buffer
	LONG m_OutBufferSize;		//bytes in each buffer
	LONG m_InBufPosition;
	LONG m_OutBufPosition;
	DWORD m_InSampleLimit;
	DWORD m_InSamplesRead;
	DWORD m_OutSampleLimit;
	DWORD m_OutSamplesWritten;
	HWAVEIN m_hwvin;
	HWAVEOUT m_hwvout;
	WAVEFORMATEX m_OutFormat;
	WAVEFORMATEX m_InFormat;
	volatile LPWAVEHDR m_pInputBuffer[NUM_INPUT_SNDBUFFERS];	// soundcard input buffers
	volatile LPWAVEHDR m_pOutputBuffer[NUM_OUTPUT_SNDBUFFERS];	// soundcard output buffer ptrs
	union uSWORD{
		struct xbytes{
			BYTE lsb;
			BYTE msb;
		}bytes;
		SHORT both;
	}m_usTemp;
};
	// public callback function for use in soundcard input/output functions
	void CALLBACK WaveInCallback( HWAVEIN, UINT, CSound*, DWORD, DWORD );
	void CALLBACK WaveOutCallback( HWAVEOUT, UINT, CSound*, DWORD, DWORD );
#endif // !defined(AFX_SOUND_H__0A83B9C2_549A_11D2_A141_00A0C996E7F5__INCLUDED_)
