(( Win32Forth adaptation of sound.h from AE4JY's PathSim source code

            Andy Korsak  KR6DD  Feb '06

//////////////////////////////////////////////////////////////////////
// Sound.h: interface for the CSound class.
//
//////////////////////////////////////////////////////////////////////
// Copyright 2000.    Moe Wheatley AE4JY  <ae4jy@mindspring.com>
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
////////////////////////////////////////////////////////////////////////

#if !defined(AFX_SOUND_H__0A83B9C2_549A_11D2_A141_00A0C996E7F5__INCLUDED_)
#define AFX_SOUND_H__0A83B9C2_549A_11D2_A141_00A0C996E7F5__INCLUDED_
))
   \ This Forth implementation is public domain      AK

((
#include <mmsystem.h>
))
   \  mmsystem.h is a huge file -- I anin't about to attempt translating
   \  all of it!  All we need out of it was already provided in wave.h.f .   AK


((   I have no idea what this is all about           AK
#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
))

((
#define NUM_INPUT_SNDBUFFERS 3      // number of sound input buffers to allocate
#define NUM_OUTPUT_SNDBUFFERS 3     // number of sound output buffers to allocate
))
\ Forth version:
3 value NUM_INPUT_SNDBUFFERS      \ number of sound input buffers to allocate
3 value NUM_OUTPUT_SNDBUFFERS     \ number of sound output buffers to allocate

((
//+++++++++++++   WAVEFORMATEX  member variables     +++++++++++++++++++
//typedef struct {
//    WORD  wFormatTag;
//    WORD  nChannels;
//    DWORD nSamplesPerSec;
//    DWORD nAvgBytesPerSec;
//    WORD  nBlockAlign;
//    WORD  wBitsPerSample;
//    WORD  cbSize;
//} WAVEFORMATEX;
))
    \ WAVEFORMATEX was already converted to Forth in wave.h.f -- as long as we
    \ involve wave files along with sound card access, there's no reason
    \ to redefine this as it was defined in the first part of wave.h.f
    \ ahead of the CWave vocabulary that contains "private" stuff for
    \ wave file functions.  If this file needs to be loaded for an application
    \ not involving wave files, just extract the stuff ahead of the CWave
    \ vocabulary into a separate file.                      AK

needs wave.h.f

((
class CSound
{
))
\ I could have used Win32Forth's classes, objects & methods but saw no real
\   value in doing that.        AK

vocabulary CSound  \ avoids conflicts for things using same names

also FORTH also CWave  also CSound definitions

((
public:
   CSound();
   virtual ~CSound();
   // Public member functions for object's users.
   UINT InOpen( WAVEFORMATEX* pWFX, DWORD BufSize, DWORD SampleLimit, INT card);
   LONG InRead( double* pData, INT Length );
   void InClose();
   UINT OutOpen( WAVEFORMATEX* pWFX, DWORD BufSize, DWORD SampleLimit, INT card);
   LONG OutWrite( double* pData, INT Length);
   void OutClose();
   UINT GetError(void){return m_ErrorCode;}
))
  \ In this Forth version all "functions" will be simply defined in proper order
  \ so there is no need to provide for "forward referencing".
((
   // Public variables for use by callback functions only.
   HANDLE m_InEventHandle;
   HANDLE m_OutEventHandle;
   BOOL m_InWaiting;
   BOOL m_InOverflow;
   BOOL m_OutWaiting;
   BOOL m_OutUnderflow;
   INT   m_InHeadPtr;
   INT m_InTailPtr;
   INT   m_OutHeadPtr;
   INT m_OutTailPtr;
   CRITICAL_SECTION m_CriticalSection; // use for keeping threads
                              // from stomping on each other
))

0 value m_InEventHandle
0 value m_OutEventHandle
0 value m_InWaiting
0 value m_InOverflow
0 value m_OutWaiting
0 value m_OutUnderflow
0 value m_InHeadPtr
0 value m_InTailPtr
0 value m_OutHeadPtr
0 value m_OutTailPtr

create m_CriticalSection \ use for keeping threads  from stomping on each other
here 32 cells erase   32 cells allot
m_CriticalSection 4 cells+  constant &m_CriticalSection

((
private:
   UINT WaitForFlush();
   BOOL m_InputOpen;
   BOOL m_OutputOpen;
   BOOL m_fOutputHoldoff;     //keeps output off until half the buffers are full
   INT m_InBytesTotal;
   INT m_InBytesPerSample;
   INT m_OutBytesPerSample;
   UINT m_ErrorCode;
   LONG m_InBufferSize;    //bytes in each buffer
   LONG m_OutBufferSize;      //bytes in each buffer
   LONG m_InBufPosition;
   LONG m_OutBufPosition;
   DWORD m_InSampleLimit;
   DWORD m_InSamplesRead;
   DWORD m_OutSampleLimit;
   DWORD m_OutSamplesWritten;
   HWAVEIN m_hwvin;
   HWAVEOUT m_hwvout;
   WAVEFORMATEX m_OutFormat;
   WAVEFORMATEX m_InFormat;
))

\  WaitForFlush will be defined in SoundIO.f
0 value m_InputOpen
0 value m_OutputOpen
0 value m_fOutputHoldoff   \ keeps output off until half the buffers are full
0 value m_InBytesTotal
0 value m_InBytesPerSample
0 value m_OutBytesPerSample
0 value m_ErrorCode
0 value m_InBufferSize    \ bytes in each buffer
0 value m_OutBufferSize   \ bytes in each buffer
0 value m_InBufPosition
0 value m_OutBufPosition
0 value m_InSampleLimit
0 value m_InSamplesRead
0 value m_OutSampleLimit
0 value m_OutSamplesWritten

\ These have to be "handled" differently so as to provide a data address
\ for passing to mmio functions when called by reference and value:
\ 0 value m_hwvin   cell allot    ' m_hwvin  >body constant &m_hwvin
\ 0 value m_hwvout  cell allot    ' m_hwvout >body constant &m_hwvout

here cell erase   cell allot
create &m_hwvin  32 cells allot
: NULL_to_m_hwvin   &m_hwvin 32 cells erase ;
: m_hwvin   &m_hwvin @ ;
here cell erase   cell allot
create &m_hwvout  32 cells allot
: NULL_to_m_hwvout  &m_hwvout 32 cells erase ;
: m_hwvout  &m_hwvout @ ;


((
   WAVEFORMATEX m_OutFormat;
   WAVEFORMATEX m_InFormat;
))
\ FORTH equivalents of C struct's
sizeof WAVEFORMATEX mkstruct: m_InFormat
sizeof WAVEFORMATEX mkstruct: m_OutFormat
\     Win32Forth versions of these were also made in wave.h.f

m_InFormat rel>abs constant &m_InFormat
m_OutFormat rel>abs constant &m_OutFormat

((
   volatile LPWAVEHDR m_pInputBuffer[NUM_INPUT_SNDBUFFERS];
     // soundcard input buffers
   volatile LPWAVEHDR m_pOutputBuffer[NUM_OUTPUT_SNDBUFFERS];
     // soundcard output buffer ptrs
))
\ Forth version:
needs array.f    \ Win32Forth provides arrays ( Win32Forth\src\lib )

NUM_INPUT_SNDBUFFERS  #long-array m_pInputBuffer[]
NUM_OUTPUT_SNDBUFFERS #long-array m_pOutputBuffer[]
   \ These will hold pointers to structs. A #long-array deposits the contents
   \ of the selected array element at run time.  In order to write to it
   \ you could use l#-> and l#+> to increment it by a number at t.o.s.,
   \ but we'll only use l#-> to set/erase the array pointer values, and
   \ will just read and write the fields using the struct field access words
   \ like lpData to get us to a field address.
   \ The net effect will be that it appears just like working with an array
   \ of structs as in C++ except that we replace the -> by a space.

0 value InputBuffer    \ temporary holders for contents at current locations
0 value OutputBuffer   \ in the above arrays during a loop iteration

((
/* wave data block header */
typedef struct wavehdr_tag {
    LPSTR       lpData;                 /* pointer to locked data buffer */
    DWORD       dwBufferLength;         /* length of data buffer */
    DWORD       dwBytesRecorded;        /* used for input only */
    DWORD       dwUser;                 /* for client's use */
    DWORD       dwFlags;                /* assorted flags (see defines) */
    DWORD       dwLoops;                /* loop control counter */
    struct wavehdr_tag FAR *lpNext;     /* reserved for driver */
    DWORD       reserved;               /* reserved for driver */
} WAVEHDR, *PWAVEHDR, NEAR *NPWAVEHDR, FAR *LPWAVEHDR;

/* flags for dwFlags field of WAVEHDR */
#define WHDR_DONE       0x00000001  /* done bit */
#define WHDR_PREPARED   0x00000002  /* set if this header has been prepared */
#define WHDR_BEGINLOOP  0x00000004  /* loop start block */
#define WHDR_ENDLOOP    0x00000008  /* loop end block */
#define WHDR_INQUEUE    0x00000010  /* reserved for driver */
))

\ Wn32Forth implementation using struct.f

\  wave data block header
struct{ \ wavehdr_tag
    long        lpData               \  /* pointer to locked data buffer */
    DWORD       dwBufferLength       \  /* length of data buffer */
    DWORD       dwBytesRecorded      \  /* used for input only */
    DWORD       dwUser               \  /* for client's use */
    DWORD       dwFlags              \  /* assorted flags (see defines) */
    DWORD       dwLoops              \  /* loop control counter */
    long        *lpNext   \  /* reserved for driver */
    DWORD       reserved             \  /* reserved for driver */
}struct  WAVEHDR


((
   union uSWORD{
      struct xbytes{
         BYTE lsb;
         BYTE msb;
      }bytes;
      SHORT both;
   }m_usTemp;
};
))
\ The above is just like the one in wave.h, so we could just use that one,
\ but then we'd have to temporarily invoke the CWave vocabulary, it is
\ reproduced here:

struct{ \ bytes
    BYTE lsb
    BYTE msb
}struct  bytes

sizeof bytes mkstruct: m_usTemp.bytes

m_usTemp.bytes lsb constant  m_usTemp.both

((
   // public callback function for use in soundcard input/output functions
   void CALLBACK WaveInCallback( HWAVEIN, UINT, CSound*, DWORD, DWORD );
   void CALLBACK WaveOutCallback( HWAVEOUT, UINT, CSound*, DWORD, DWORD );
#endif // !defined(AFX_SOUND_H__0A83B9C2_549A_11D2_A141_00A0C996E7F5__INCLUDED_)
))

\ We don't need forward references for the callback's -- we'll just
\ write them ahead of calling them    AK

sizeof WAVEFORMATEX mkstruct: InWFX
 InWFX rel>abs constant pInWFX

sizeof WAVEFORMATEX mkstruct: OutWFX
 OutWFX rel>abs constant pOutWFX
\ The above are just like the ones in wave.h, so we could just use that those,
\ but then we'd have to temporarily invoke the CWave vocabulary, and there could
\ be a conflict if we concurrently read the soundcard and write a wavefile.



