-- eM24
-- em24a	03jun00cht, expand cpu16 to 24 bits
-- em24e1	11jun00cht, add sks, skr, lld, lst
-- em24e2	11jun00cht, use named signals in muxes
-- em24e3	13jun00cht, bidirectional data bus
-- em24e4	15jun00cht, rearrange opcode, add test_in, test_out
-- em24f1	10jul00cht, new instruction set, failed
-- em24f2	11jul00cht, start from e4, proceed slowly
-- em24f3	14jul00cht, consolidate incrementors p,x,y. no good.
-- em24f4	14jul00cht, eliminate p-mux, no good
-- em24f5	14jul00cht, change shr for no-cost uart, decy now is next.
--		16jul00cht, change depth to 15.
--		17jul00cht, change depth back to 7, delete test_in/out.
-- em24f6	06aug00cht, xy/sr_depth, change n to s.
-- em25a1	06aug00cht, use core generator for stacks.
-- em25a2	07aug00cht, use ramb4_s16_s16 for stacks.
-- em25a3	09aug00cht, add code to memory
-- em25a4	10aug00cht, eni to replace bbt
-- em25a5	14aug00cht, code in memory
-- em25a6	14aug00cht, change to ldrp and strp, fix slot
--		useattribute for code initialization
--		16aug00cht, test Diagnose
-- em25a7	18aug00cht, eliminate r,x,y registers
-- cpu24a1	01sep00cht, adapted from em25a7 and cpu16
-- cpu24b	07nov00cht, real tests
--			change x back to a.
--			put stacks back to logic.
-- p24c		02dec00cht, 6 bit instructions, mul, div, interrupts


library ieee;
use ieee.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_misc.all;
use IEEE.std_logic_unsigned.all;

-- Simulation netlist only
-- synopsys translate_off
library UNISIM;
use UNISIM.vcomponents.all;
-- synopsys translate_on

entity cpu24 is 
	generic(width: integer := 24);
	port(
	holdosc0: out std_logic;
	clk,aclr,uart_in: in std_logic;
	icode: out std_logic_vector(5 downto 0);
	interrupt: in std_logic_vector(4 downto 0);
	uart_out: out std_logic;
	data: out std_logic_vector(width-1 downto 0);
	address: out std_logic_vector(10 downto 0));

end entity cpu24;

architecture archcpu24 of cpu24 is

component RAMB4_S16_S16 
	port (
	ADDRA : in STD_LOGIC_VECTOR (7 downto 0);
	ADDRB : in STD_LOGIC_VECTOR (7 downto 0);
	DIA : in STD_LOGIC_VECTOR (15 downto 0);
	DIB : in STD_LOGIC_VECTOR (15 downto 0);
	DOA : out STD_LOGIC_VECTOR (15 downto 0);
	DOB : out STD_LOGIC_VECTOR (15 downto 0);
	CLKA : in STD_LOGIC;
	CLKB : in STD_LOGIC;
	ENA : in STD_LOGIC;
	ENB : in STD_LOGIC;
	RSTA : in STD_LOGIC;
	RSTB : in STD_LOGIC;
	WEA : in STD_LOGIC;
	WEB : in STD_LOGIC
); end component;

	signal slot: integer range 0 to 4;
	type stack is array(15 downto 0) of std_logic_vector(width downto 0);
	signal s_stack,r_stack: stack;
	signal sp,sp1,rp,rp1: integer range 0 to 15; 
	signal t,s,i,p,sum: std_logic_vector(width downto 0);
	signal a,r: std_logic_vector(width downto 0);
	signal t_in,s_in,r_in,a_in,p_in: std_logic_vector(width downto 0);
	signal skip_sel: std_logic_vector(5 downto 0);
	signal code: std_logic_vector(5 downto 0);
	signal t_sel: std_logic_vector(3 downto 0);
	signal p_sel: std_logic_vector(2 downto 0);	
	signal a_sel,addr_sel: std_logic_vector(2 downto 0);
	signal r_sel: std_logic_vector(1 downto 0);
	signal spush,spopp,rpush,rpopp,
		tload,aload,pload,iload,reset,z: std_logic;
	signal write,uload: std_logic;
	signal clk0,clr: std_logic;
	signal addr: std_logic_vector(10 downto 0);
	signal m_adda,m_addb: std_logic_vector(7 downto 0);
	signal data_out,data_in: std_logic_vector(31 downto 0);
	signal data_a,data_b: std_logic_vector(16 downto 0);
	signal data_out0,data_out1,data_out2,data_out3: std_logic_vector(31 downto 0);		
	signal data_out4,data_out5,data_out6,data_out7: std_logic_vector(31 downto 0);
	signal data_out8,data_out9,data_outA,data_outB: std_logic_vector(31 downto 0);	
	signal data_outC,data_outD,data_outE,data_outF: std_logic_vector(31 downto 0);	
	signal writeF: std_logic;	
	signal mem_sel: std_logic_vector(3 downto 0);
	
-- machine instructions selected by code
	constant jmp : std_logic_vector(5 downto 0) :="000000";
	constant ret : std_logic_vector(5 downto 0) :="000001";
	constant jz  : std_logic_vector(5 downto 0) :="000010";
	constant jnc : std_logic_vector(5 downto 0) :="000011";
	constant call: std_logic_vector(5 downto 0) :="000100";
	constant ldp : std_logic_vector(5 downto 0) :="001001";
	constant lit : std_logic_vector(5 downto 0) :="001010";
	constant ld  : std_logic_vector(5 downto 0) :="001011";
	constant stp : std_logic_vector(5 downto 0) :="001101";
	constant st  : std_logic_vector(5 downto 0) :="001111";
	constant com : std_logic_vector(5 downto 0) :="010000";
	constant shl : std_logic_vector(5 downto 0) :="010001";
	constant shr : std_logic_vector(5 downto 0) :="010010";
	constant mul : std_logic_vector(5 downto 0) :="010011";
	constant xorr: std_logic_vector(5 downto 0) :="010100";
	constant andd: std_logic_vector(5 downto 0) :="010101";
	constant div : std_logic_vector(5 downto 0) :="010110";
	constant addd: std_logic_vector(5 downto 0) :="010111";
	constant pop : std_logic_vector(5 downto 0) :="011000";
	constant lda : std_logic_vector(5 downto 0) :="011001";
	constant dup : std_logic_vector(5 downto 0) :="011010";
	constant push: std_logic_vector(5 downto 0) :="011100";
	constant sta : std_logic_vector(5 downto 0) :="011101";
	constant nop : std_logic_vector(5 downto 0) :="011110";
	constant drop: std_logic_vector(5 downto 0) :="011111";

-- mux to t register, selected by t_sel
	constant not_t: std_logic_vector :="0000";
	constant s_xor_t: std_logic_vector :="0001";
	constant s_and_t: std_logic_vector :="0010";
	constant s_or_t: std_logic_vector :="0011";
	constant sum_t: std_logic_vector :="0100";
	constant shr_sum: std_logic_vector :="0101";
	constant shr_t: std_logic_vector :="0110";
	constant shr_t_t: std_logic_vector :="0111";
	constant shl_sum_a_t: std_logic_vector :="1000";
	constant shl_t_a_t: std_logic_vector :="1001";
	constant shl_t: std_logic_vector :="1010";
	constant s_t: std_logic_vector :="1011";
	constant a_t: std_logic_vector :="1100";
	constant r_t: std_logic_vector :="1101";
	constant data_t: std_logic_vector :="1110";

-- mux to a register, selected by a_sel
	constant t_a: std_logic_vector :="001";
	constant a1_a: std_logic_vector :="010";
	constant shr_sum_a: std_logic_vector :="011";
	constant shr_t_a: std_logic_vector :="100";
	constant shl_sum_a: std_logic_vector :="101";

-- mux to r register, selected by r_sel
	constant rout_r: std_logic_vector :="00";
	constant t_r: std_logic_vector :="01";
	constant r1_r: std_logic_vector :="10";
	constant p_r: std_logic_vector :="11";

-- mux to p register, selected by p_sel
	constant i_p: std_logic_vector :="000";
	constant pi_p: std_logic_vector :="001";
	constant p1_p: std_logic_vector :="010";
	constant r_p: std_logic_vector :="011";
	constant int_p: std_logic_vector :="100";

-- mux to memory bus, selected by addr_sel
	constant p_addr: std_logic_vector :="000";
	constant a_addr: std_logic_vector :="001";
	constant r_addr: std_logic_vector :="010";
	constant ai_addr: std_logic_vector :="011";
	constant zi_addr: std_logic_vector :="100";
	constant ziz_addr: std_logic_vector :="101";
	constant y_addr: std_logic_vector :="110";

--ATRIBUTES
attribute INIT_00: string;
attribute INIT_01: string;
attribute INIT_02: string;
attribute INIT_03: string;
attribute INIT_04: string;
attribute INIT_05: string;
attribute INIT_06: string;
attribute INIT_07: string;
attribute INIT_08: string;
attribute INIT_09: string;
attribute INIT_0A: string;
attribute INIT_0B: string;
attribute INIT_0C: string;
attribute INIT_0D: string;
attribute INIT_0E: string;
attribute INIT_0F: string;

attribute INIT_00 of memory0:label is "0065861D0071D25C0071C79E000005E20000000600000704000000100028A28A";
attribute INIT_01 of memory0:label is "00000000000000000000000000000000007DF04000000006001000250035979E";
attribute INIT_02 of memory0:label is "000000000000047F0000044B000006E100000780000006E10000000A00000730";
attribute INIT_03 of memory0:label is "0061D259004C49540005646F000000190060179E005641520005646F00000000";
attribute INIT_04 of memory0:label is "0029771C0008002A0061869E00540000004E45580006646F0000001D0070179E";
attribute INIT_05 of memory0:label is "0045E79E0002303C000000220005E79E00000001007CA5DC0005E79E00FFFFFF";
attribute INIT_06 of memory0:label is "0055005E0041C41800024F520000002E0069405E00FFFFFF007CA05E000C0033";
attribute INIT_07 of memory0:label is "0069A501000000010028179E000C003F005DE79E002B00000003554D00000035";
attribute INIT_08 of memory0:label is "000000410005E79E0068179E000800460069E79E0055500000043F4400000039";
attribute INIT_09 of memory0:label is "0069C71A0055500000043244000000480061905E0071C758005400000003524F";
attribute INIT_0A of memory0:label is "000000010041C40A00544500004547410007444E0000004D0005E79E00758658";
attribute INIT_0B of memory0:label is "005300000003414200000053000000010060A5C10060179E000C005B005DE79E";
attribute INIT_0C of memory0:label is "00013D000000005E007C179E0005E79E00000001007D0297000C00650069179E";
attribute INIT_0D of memory0:label is "0075C358000232210000006700FFFFFF0028179E0069A5010008006B0051E79E";
attribute INIT_0E of memory0:label is "0074971900554E540005434F00000072007492C1000232400000006E003C179E";
attribute INIT_0F of memory0:label is "004573D900451451002D14510065861D0071D25C0002423E000000750060179E";

attribute INIT_00 of memory1:label is "0060A54A000000FF0069C2950065861D0071D25C00023E420000007A0005E79E";
attribute INIT_01 of memory1:label is "00FFFF0000558295000000FF0049A70A0049249200512492000000FF00FFFF00";
attribute INIT_02 of memory1:label is "00000082003596010069C34D000000FF0049229500492492000000FF00294492";
attribute INIT_03 of memory1:label is "003075730005313000000098000000A2000000040029E79E0075730000043530";
attribute INIT_04 of memory1:label is "0000009E007C179E000C00A40065779E00FFFFFA0074A79E000000020029E79E";
attribute INIT_05 of memory1:label is "0049E79E0000000A0050A71E00FFFF010000007F0029544A004954000004454D";
attribute INIT_06 of memory1:label is "0029E79E0059000000034B45000000A8007C179E000000AF00100025001000A0";
attribute INIT_07 of memory1:label is "001000A0000000070029C79E0010009A000000B9000C00BC0049E79E00FFFFFF";
attribute INIT_08 of memory1:label is "0029579E000000BF00100025000000800029479E000000C5000C00C30049E79E";
attribute INIT_09 of memory1:label is "0010002F0051E79E0010004F0002553C000000B50005E79E001000A0000000FF";
attribute INIT_0A of memory1:label is "0000002F00000001004172970005E79E0010002F007DE79E0071D619000800D5";
attribute INIT_0B of memory1:label is "0010002F007DE79E000800E10010002F0051E79E0010004F00013C00000000CC";
attribute INIT_0C of memory1:label is "0010004F0058000000034D41000000D90000002F00000001004172970005E79E";
attribute INIT_0D of memory1:label is "0010004F004E000000034D49000000E5007C179E0071D619000800EB001000DA";
attribute INIT_0E of memory1:label is "0054484900065749000000ED007C179E0071D619000800F4001000DA0071D619";
attribute INIT_0F of memory1:label is "000000CD000000010029761E005DC41700000001006505CA0071A758004E0000";

attribute INIT_00 of memory2:label is "0061879E0071971D000000010040A5DD00440000002F4D4F0006554D000000F6";
attribute INIT_01 of memory2:label is "000000000075829E000000010040A5DC004F440000042F4D0000010100000110";
attribute INIT_02 of memory2:label is "000000010058A512005965960059659600596596005965960059659600596596";
attribute INIT_03 of memory2:label is "0000011B007C179E0010010C0044000000034D4F0000010A0005E79E0071F619";
attribute INIT_04 of memory2:label is "0010002F0069E79E004D4F4400054D2F000001200071F6010010010C00012F00";
attribute INIT_05 of memory2:label is "0010002F0071A79E0061E79E00100056000000010040A5DC0008012E0069C79E";
attribute INIT_06 of memory2:label is "0040A5DC0071D6190008013A0061E79E001001040061E79E0061A71700080132";
attribute INIT_07 of memory2:label is "000000000074A4D3002A00000003554D000001240005E79E0075865E00000001";
attribute INIT_08 of memory2:label is "0000013C0065805E004D371F004D34D3004D34D3004D34D3004D34D3004D34D3";
attribute INIT_09 of memory2:label is "0010002F0051E79E0010004F00024D2A00000148007C179E0010013E00012A00";
attribute INIT_0A of memory2:label is "00100056000801580061E79E0010013E001000600071D619001000600071E79E";
attribute INIT_0B of memory2:label is "000001260061E79E0010014D0071E79E004D4F4400052A2F0000014C0005E79E";
attribute INIT_0C of memory2:label is "0048415200053E4300000161007C179E0071D6190010015C00022A2F0000015A";
attribute INIT_0D of memory2:label is "007CA79E00080171001000F9000000200029E79E0000007F0000007F0029568A";
attribute INIT_0E of memory2:label is "00000173000007070029D2C10052450000044845000001660005E79E0000005F";
attribute INIT_0F of memory2:label is "0003544900000178005C179E00000050000007070029D2CA0044000000035041";

attribute INIT_00 of memory3:label is "0074B79E0055544500584543000840450000017F000007040029D2C100420000";
attribute INIT_01 of memory3:label is "0071E79E004F56450005434D000001840005E79E0070179E0008018B00100043";
attribute INIT_02 of memory3:label is "00100025000000010029779E00000001003CA5D80061A71D0071A74B00000197";
attribute INIT_03 of memory3:label is "0071D6190071E79E0071D619004C4C00000446490000018D007DF05E00000191";
attribute INIT_04 of memory3:label is "0000019B007DF05E000001A100100025000000010074F2970010004F000001A4";
attribute INIT_05 of memory3:label is "0071E79E0070F6580074F75A0000070B000000010069C28A00434B2400055041";
attribute INIT_06 of memory3:label is "000801BC00000001002CA51E000801BF0000070B0029D2DE0010007B000001C1";
attribute INIT_07 of memory3:label is "0028F79E000001C1000000020028F79E000001BE000000010029779E0069A50F";
attribute INIT_08 of memory3:label is "00000002002CA51E000801CF0000070B0029D2DE000001B10010002500000001";
attribute INIT_09 of memory3:label is "007DF601004513D9004514510074B451004513D9004514510074B451000801CC";
attribute INIT_0A of memory3:label is "0000001F0029529E001000830069C79E004B2400005041430007554E000001A8";
attribute INIT_0B of memory3:label is "000001DC00100025007DE79E00100083000001DE0071E79E0010012100000003";
attribute INIT_0C of memory3:label is "001000DA0061979E000000090029C69D0047495400054449000001D1007DF601";
attribute INIT_0D of memory3:label is "004354000054524100074558000001E2005C179E0000003000000007002955CA";
attribute INIT_0E of memory3:label is "00023C23000001ED000001E40071D619001001040065E79E000000000029C758";
attribute INIT_0F of memory3:label is "000007000029D2CA004C44000004484F000001F7000007000029D3C10010017A";

attribute INIT_00 of memory4:label is "000007050029D2DE00012300000001FC003DD3C100000700005DA29D00FFFFFF";
attribute INIT_01 of memory4:label is "0000020C000802100069E79E001002060002235300000205000001FE001001F0";
attribute INIT_02 of memory4:label is "0000002D0029E79E000802190010002F00474E00000453490000020B0005E79E";
attribute INIT_03 of memory4:label is "0071A7580010017A00000700007CA74B0002233E000002120005E79E001001FE";
attribute INIT_04 of memory4:label is "001000600069C79E00720000000373740000021B005C179E00000001006505CA";
attribute INIT_05 of memory4:label is "0058000000034845000002240000021C001002140061E79E0010020C001001F8";
attribute INIT_06 of memory4:label is "00414C000043494D000744450000022E0005E79E00000705000000100028A74F";
attribute INIT_07 of memory4:label is "003F00000047495400064449000002350005E79E000007050000000A0028A74F";
attribute INIT_08 of memory4:label is "0008024F001000DA0069D61900000009000000010029729C000000300070A417";
attribute INIT_09 of memory4:label is "0069879E00100036001000DA0000000A005DA29E0000000100000007002905CA";
attribute INIT_0A of memory4:label is "0029C69D000007050029D2DC00523F00004D424500074E550000023D000000CD";
attribute INIT_0B of memory4:label is "0008026600100068000000240065D2CA0071A758001000770061979E00000000";
attribute INIT_0C of memory4:label is "0065D2CA0071A75800FFFFFF00619297000000010029771D0071D61900100230";
attribute INIT_0D of memory4:label is "0061A7170071D61900000001004172970065869C0071C758001000680000002D";
attribute INIT_0E of memory4:label is "00100240000007050029D2DE0069C74B00FFFFFF0029771E0008028B00100043";
attribute INIT_0F of memory4:label is "0010002500000001005D829700100149000007050029D2DE0071D61900080287";

attribute INIT_00 of memory5:label is "006187DF0000028A0071D619000000010040A5DE00080285007D869C00000274";
attribute INIT_01 of memory5:label is "0005535000000252000007050029D3C10061F7D80069E79E00000000007DF29E";
attribute INIT_02 of memory5:label is "0071D61900415253000543480000028F000000AA000000200029E79E00414345";
attribute INIT_03 of memory5:label is "00100025001000AA0069E79E0000029F0071E79E001000E7000000000029E79E";
attribute INIT_04 of memory5:label is "000000200029E79E00530000004143450006535000000295007C179E0000029D";
attribute INIT_05 of memory5:label is "001001680069D2DE000002B30071E79E0050450000045459000002A300000297";
attribute INIT_06 of memory5:label is "00024352000002AA007C179E000002AE00100025000000010029779E001000AA";
attribute INIT_07 of memory5:label is "002400000003646F000002B7000000AA001000AA0000000D0000000A0028A79E";
attribute INIT_08 of memory5:label is "0029E79E003FFFFF0074B2950061A718001001D4000007100029E79E0061869C";
attribute INIT_09 of memory5:label is "00032422000002BE0070179E0071D61900000001002975DC0010012100030000";
attribute INIT_0A of memory5:label is "000002AC00100077001002C0007C000000032E22000002CF000002C0007C0000";
attribute INIT_0B of memory5:label is "000000010029779E006194170061C69D001002260071E79E00022E52000002D3";
attribute INIT_0C of memory5:label is "0010020C001001F80071E79E005200000003552E000002D9000002AC001002A6";
attribute INIT_0D of memory5:label is "000002E3000002AC001002A6000000010029779E006194170061C69D0010021C";
attribute INIT_0E of memory5:label is "00012E00000002F0000002AC001002910010021C0010020C001001F80002552E";
attribute INIT_0F of memory5:label is "001002260005E79E001002F1000802FF0051E79E0000000A000007050029D2CA";

attribute INIT_00 of memory6:label is "0007287000000303000002F80074B79E00013F00000002F7000002AC00100291";
attribute INIT_01 of memory6:label is "0029729D000803460071A79E0069D6190000070B0029D3DC0065290000617273";
attribute INIT_02 of memory6:label is "0029C69D0071E79E000803270010006800000020002CA79E0000070B00FFFFFF";
attribute INIT_03 of memory6:label is "0029779E000803260041E79E0010002F00000001004172970061974B00000020";
attribute INIT_04 of memory6:label is "0071A7580061E79E0005E79E000000000061F29A000003170010002500000001";
attribute INIT_05 of memory6:label is "000000010029729D0074B4170069D6190000070B0029D2DC0065C79E0065C758";
attribute INIT_06 of memory6:label is "0029779E0008033D0010002F000803360010006800000020002CA79E0000070B";
attribute INIT_07 of memory6:label is "005DC79E000000010061F68A000003400069C79E0000032A0010002500000001";
attribute INIT_08 of memory6:label is "006584170071A75800000001005CA5C1005D861000000001006505CA0071A758";
attribute INIT_09 of memory6:label is "0029D2D7001001810071E79E005253450005504100000307000000010029705E";
attribute INIT_0A of memory6:label is "0010030A000000010029761E0074B41700000702000007030029D2CA00000702";
attribute INIT_0B of memory6:label is "000000200029E79E004B454E0005544F0000034B003C179E000007020029D2D7";
attribute INIT_0C of memory6:label is "0028A5DC000007100068A74F0010004F001000EF0000001F0029E79E0010034D";
attribute INIT_0D of memory6:label is "000001AA000000010029779E001001750010018F0075865E0000000100000710";
attribute INIT_0E of memory6:label is "000001AA000000010029779E001001750010034D005244000004574F0000035C";
attribute INIT_0F of memory6:label is "00100121000300000054A79E003FFFFF0069D2CA004D453E00054E4100000371";

attribute INIT_00 of memory7:label is "00100121000300000029E79E004D453F000553410000037900000001005CA5C1";
attribute INIT_01 of memory7:label is "0074B4170061A7170069D619005DD2DC0065869C0071A758000003950071E79E";
attribute INIT_02 of memory7:label is "0028179E0000038A001000250061F05E0008039500100043000000010029779E";
attribute INIT_03 of memory7:label is "0074F69D0000070B0069D2CA0071D619006E6400000466690000038300000000";
attribute INIT_04 of memory7:label is "0055869C003FFFFF0069D2CA000803B40074B69E0071D61900000001002DC297";
attribute INIT_05 of memory7:label is "000000010029729D000003B300FFFFFF000000010029729E000803AE0051E79E";
attribute INIT_06 of memory7:label is "0071D61900FFFFFF006192970061F71D000003B900100385002DE79E0000070B";
attribute INIT_07 of memory7:label is "006197CA0061F71D000003A300FFFFFF00FFFFFF00297297000803BE0005E79E";
attribute INIT_08 of memory7:label is "004D453F00054E410000039A0005E79E0071D6190010037B005DA79E00FFFFFF";
attribute INIT_09 of memory7:label is "0075865C0061961C0071C69D00025E48000003C60000039C000007060029E79E";
attribute INIT_0A of memory7:label is "00FFFFFF0029729E001000AA000000080029E79E000803DD0051E79E0069D619";
attribute INIT_0B of memory7:label is "00035441000003CC0005E79E001000AA000000080029E79E001000AA00000020";
attribute INIT_0C of memory7:label is "000003DF005C179E000000010065D3CA0071A758001000AA0069E79E00500000";
attribute INIT_0D of memory7:label is "000803F4000000080029479E000803F60000000D0068A51E0041500000046B54";
attribute INIT_0E of memory7:label is "0065F681007DC7580005E79E001003CD000003F5001003E1000000200029E79E";
attribute INIT_0F of memory7:label is "0010004F0075865E0065771A0071A758007400000063657000066163000003E8";

attribute INIT_00 of memory8:label is "0000005F000000010029729E000000200068A417001000B70008040E0051E79E";
attribute INIT_01 of memory8:label is "00619417007DC69D000003FF001003EA0000040D001003E10008040C001000CD";
attribute INIT_02 of memory8:label is "0029D3DF001003FC005400000050454300064558000003F9000000010029705E";
attribute INIT_03 of memory8:label is "000000500029E79E001001810045525900055155000004130005E79E00000701";
attribute INIT_04 of memory8:label is "0000041B0005E79E00000702000000000028A74F000007030029D3DF001003FC";
attribute INIT_05 of memory8:label is "00066162000004280005E79E001001870000070A0029E79E004F525400054142";
attribute INIT_06 of memory8:label is "001002C00010042A001002AC00100077001002C00008043700220000006F7274";
attribute INIT_07 of memory8:label is "00100077000007100029E79E0010029100524F52000545520000042F007C179E";
attribute INIT_08 of memory8:label is "000A24490000043A0010042A001002B8001000AA0000003F0029E79E001002AC";
attribute INIT_09 of memory8:label is "004000000074B2950008045700100043001003C80045540000525052004E5445";
attribute INIT_0A of memory8:label is "007CA79E0070105E00790000006F6E6C006C6520006D7069000C636F00100432";
attribute INIT_0B of memory8:label is "0028A74F00815B00000004470010043C0005E79E0008045C0010025500000710";
attribute INIT_0C of memory8:label is "0000044B0028A74B004B000000032E4F0000045E0005E79E000007090000044B";
attribute INIT_0D of memory8:label is "0005E79E001002B8004B00000003204F001002D50008046F0010006800000709";
attribute INIT_0E of memory8:label is "000007090029E79E0008047A0069D2DE0010035E00414C000004455600000464";
attribute INIT_0F of memory8:label is "0028A74F00495400000451550000047100000466007DE79E0000047300100187";

attribute INIT_00 of memory9:label is "000127000000047D00000483001004730010041D0010045F0000070400000730";
attribute INIT_01 of memory9:label is "004C4F540005414C000004870010043C0005E79E0008048C001003C80010035E";
attribute INIT_02 of memory9:label is "000000010068A5CA0010017500012C000000048E003C179E000007070029D2D7";
attribute INIT_03 of memory9:label is "005D000000494C45004F4D5000895B43000004940005E79E0074F74F00000707";
attribute INIT_04 of memory9:label is "004D50490007434F0000049C0000049500100036001000000029E79E00100488";
attribute INIT_05 of memory9:label is "0054455200874C49000004A60000000100297701001004950061A74B004C4500";
attribute INIT_06 of memory9:label is "002200000003242C000004AE00000495001004950029E79E0029E79E00414C00";
attribute INIT_07 of memory9:label is "00073F55000004B600000490000000010074B29700100373000000220029E79E";
attribute INIT_08 of memory9:label is "00100077000007100029E79E000804CD001003C80069E79E00554500004E4951";
attribute INIT_09 of memory9:label is "0003242C000004BF007C179E006620000065446500072072001002D5001002AC";
attribute INIT_0A of memory9:label is "000007070029D3DA0010037B0069A79E001004C2000804DF0069D2DE006E0000";
attribute INIT_0B of memory9:label is "0010043C0074F05E0071D61900000706005CA74B00FFFFFF000007080029D3CA";
attribute INIT_0C of memory9:label is "0074B295000804F200100043001003C800494C45004F4D5000082443000004CF";
attribute INIT_0D of memory9:label is "00100036001000000003FFFF0029529E000004F10070179E000804EC00800000";
attribute INIT_0E of memory9:label is "0005E79E001004B1000804F80010025500000710007CA79E0005E79E00100495";
attribute INIT_0F of memory9:label is "0074F05E00000706000007080029D2CA0045525400054F56000004E10010043C";

attribute INIT_00 of memoryA:label is "00000501000004FC0010045F001004950005E79E0029E79E00813B00000004FA";
attribute INIT_01 of memoryA:label is "0010035E00013A00000005080005E79E00000709000004E40028A74F00015D00";
attribute INIT_02 of memoryA:label is "000000070064A79E0071A758002B00000003646D0000050E00000509001004D1";
attribute INIT_03 of memoryA:label is "0029779E001002E5000000070069D2CA000005210071E79E00100291001002E5";
attribute INIT_04 of memoryA:label is "0029D2DC004D500000044455000005130005E79E0000051C0010002500000001";
attribute INIT_05 of memoryA:label is "001002B8000005340071E79E00100121000000080029E79E0010023000000705";
attribute INIT_06 of memoryA:label is "00000705007D829D0000052F00100025001005150010004F000000080029E79E";
attribute INIT_07 of memoryA:label is "0008054A0074B69E000007060029E79E00414D4500053E4E00000525003C179E";
attribute INIT_08 of memoryA:label is "0071D6190000054900FFFFFF0029779E000805470051E79E0010037B0010004F";
attribute INIT_09 of memoryA:label is "0029E79E0044000000032E490000053A007C179E0071D6190000053E007C179E";
attribute INIT_0A of memoryA:label is "0000054D00000291001002AC0000001F0029579E00100077001001D400000710";
attribute INIT_0B of memoryA:label is "0029569E0069D2DA000000200029C79E001002B8001004880045000000035345";
attribute INIT_0C of memoryA:label is "0000056E00100291001002F100080568001000000029479E0008056400FC0000";
attribute INIT_0D of memoryA:label is "000000010029779E0010054F0008056E001000430010053C0003FFFF0029579E";
attribute INIT_0E of memoryA:label is "007C179E0008055C001000680000000D0029E79E001000B70000055E00100025";
attribute INIT_0F of memoryA:label is "001000430074B79E000007060029E79E001002B8005244530005574F00000558";

attribute INIT_00 of memoryB:label is "0005E79E0000057E00FFFFFF0029779E0010054F001002910069E79E00080587";
attribute INIT_01 of memoryB:label is "0034D7DE0034D34D0034D34D0034D34D0074D34D0010017A00022E5300000579";
attribute INIT_02 of memoryB:label is "00100025000000010029779E001003040069E79E000000100029C79E0010017A";
attribute INIT_03 of memoryB:label is "0041474E0008444900000589000002B80074B79E0010017A007DE79E00000593";
attribute INIT_04 of memoryB:label is "0010002F00FFFFFE0029E79E0010002F00000000000000650028A79E004F5345";
attribute INIT_05 of memoryB:label is "0010003B00000043007CA79E0010003B0010003B00000003007CA79E0010003B";
attribute INIT_06 of memoryB:label is "0028A71D001000360000004F000000F00029529E0000006F0000004F007CA294";
attribute INIT_07 of memoryB:label is "0010003B00000070000000030029554A007586540061971A0000000600000008";
attribute INIT_08 of memoryB:label is "000805CB00FFFFFF0029E79E0000003F0029E79E000805C500000000007CA79E";
attribute INIT_09 of memoryB:label is "00000700000000680028A74F000000210029E79E000005CD000000740029E79E";
attribute INIT_0A of memoryB:label is "0071E79E0000006A000000010061528A0071869C0000004D000007000029D2CA";
attribute INIT_0B of memoryB:label is "0000059E0005E79E000005D800100025007DE79E0010003B000000010029E79E";
attribute INIT_0C of memoryB:label is "0029E79E0034207600055032001002D5001002B8001005A1004C44000004434F";
attribute INIT_0D of memoryB:label is "00100206001001FE0000002E0029E79E0010020600100206001001F800000066";
attribute INIT_0E of memoryB:label is "0029E79E0010017500824946000005E00010047F001002B8001002AC0010021C";
attribute INIT_0F of memoryB:label is "001004950071E79E0029E79E005200000083464F000005F50000049500080000";

attribute INIT_00 of memoryC:label is "004541440085414800000602000001750047494E00854245000005FB00000175";
attribute INIT_01 of memoryC:label is "000004950041494E008541470000060600000495000000000029E79E00100175";
attribute INIT_02 of memoryC:label is "000006110005E79E0074B5CF0071D6190010017500454E00008454480000060D";
attribute INIT_03 of memoryC:label is "0054494C0085554E000006180000049500100025001004A90058540000844E45";
attribute INIT_04 of memoryC:label is "0010060F0054000000504541008652450000061E00000495000800000029779E";
attribute INIT_05 of memoryC:label is "0071D6190010060400100608007DE79E00540000008341460000062400000613";
attribute INIT_06 of memoryC:label is "00000632000006130071D61900100608005345000084454C0000062A0005E79E";
attribute INIT_07 of memoryC:label is "0049540000044558000006380005E79E0071D619001005F600494C4500855748";
attribute INIT_08 of memoryC:label is "00012100000006420070179E0054450000454355000745580000063E0061F05E";
attribute INIT_09 of memoryC:label is "0070179E0061D6190002523E0000064A0074B05E00014000000006470074F05E";
attribute INIT_0A of memoryC:label is "0005E79E0075871900023E5200000651007197010061D61A000252400000064D";
attribute INIT_0B of memoryC:label is "0045520000044F56000006590005E79E0071D619004150000004535700000655";
attribute INIT_0C of memoryC:label is "00012B0000000663007DF05E00524F50000532440000065E0064179E0071A758";
attribute INIT_0D of memoryC:label is "0047415400064E450000066A0040179E0054000000034E4F00000667005C179E";
attribute INIT_0E of memoryC:label is "0000067400FFFFFF0029705E0002312D0000066E000000010040A5C100450000";
attribute INIT_0F of memoryC:label is "0000067C000000200028179E0002424C00000678000000010029705E0002312B";

attribute INIT_00 of memoryD:label is "0005E79E000000010041729700012D00000006800005E79E0074B5CF00022B21";
attribute INIT_01 of memoryD:label is "004F500000044452000006890005E79E0010068B005000000003445500000684";
attribute INIT_02 of memoryD:label is "000006930005E79E00100695004400000003414E0000068E0005E79E00100690";
attribute INIT_03 of memoryD:label is "0010069F004D00000003434F000006980005E79E0010069A005200000003584F";
attribute INIT_04 of memoryD:label is "001004B8001006A5001004A900220000004F5254008641420000069D0005E79E";
attribute INIT_05 of memoryD:label is "000006AA0005E79E001004B8001002D1001004A900822422000006A20005E79E";
attribute INIT_06 of memoryD:label is "004445000004434F000006B00005E79E001004B8001002D5001004A900822E22";
attribute INIT_07 of memoryD:label is "001006B8004500000045415400064352000006B6000004FC001004D10010035E";
attribute INIT_08 of memoryD:label is "0029E79E001006BF00424C450052494100085641000006BC0005E79E0010001B";
attribute INIT_09 of memoryD:label is "000002AC0010034D000000290029E79E00822E28000006C30000049500000000";
attribute INIT_0A of memoryD:label is "00100648000007020029E79E0010064B000007030029E79E00815C00000006CB";
attribute INIT_0B of memoryD:label is "0005E79E001006650010034D000000290029E79E00812800000006D10005E79E";
attribute INIT_0C of memoryD:label is "00000708008000000028A79E0045000000494154004D45440009494D000006DA";
attribute INIT_0D of memoryD:label is "0005E79E001006480010064B000007080029E79E001000360010064B0010064B";
attribute INIT_0E of memoryD:label is "00000000000000000000000000000000000000000000000000000000001002B8";
attribute INIT_0F of memoryD:label is "0000000000000000000000000000000000000000000000000000000000000000";

attribute INIT_00 of memoryE:label is "0000000000000000000000000000000000000000000000000000000000000000";
attribute INIT_01 of memoryE:label is "0000000000000000000000000000000000000000000000000000000000000000";
attribute INIT_02 of memoryE:label is "0000000000000000000000000000000000000000000000000000000000000000";
attribute INIT_03 of memoryE:label is "0000000000000000000000000000000000000000000000000000000000000000";
attribute INIT_04 of memoryE:label is "0000000000000000000000000000000000000000000000000000000000000000";
attribute INIT_05 of memoryE:label is "0000000000000000000000000000000000000000000000000000000000000000";
attribute INIT_06 of memoryE:label is "0000000000000000000000000000000000000000000000000000000000000000";
attribute INIT_07 of memoryE:label is "0000000000000000000000000000000000000000000000000000000000000000";
attribute INIT_08 of memoryE:label is "0000000000000000000000000000000000000000000000000000000000000000";
attribute INIT_09 of memoryE:label is "0000000000000000000000000000000000000000000000000000000000000000";
attribute INIT_0A of memoryE:label is "0000000000000000000000000000000000000000000000000000000000000000";
attribute INIT_0B of memoryE:label is "0000000000000000000000000000000000000000000000000000000000000000";
attribute INIT_0C of memoryE:label is "0000000000000000000000000000000000000000000000000000000000000000";
attribute INIT_0D of memoryE:label is "0000000000000000000000000000000000000000000000000000000000000000";
attribute INIT_0E of memoryE:label is "0000000000000000000000000000000000000000000000000000000000000000";
attribute INIT_0F of memoryE:label is "0000000000000000000000000000000000000000000000000000000000000000";
begin
-- concurent assignments, mostly with muxes

	address <= addr(10 downto 0);
	holdosc0 <= aclr;

	clk0 <= not clk;
	clr <= not aclr;
	
	r <= r_stack(rp);
	s <= s_stack(sp);
	
	data(width-1 downto 0) <= data_out(width-1 downto 0);
	m_adda(7 downto 0) <= addr(6 downto 0) & '0';
	m_addb(7 downto 0) <= addr(6 downto 0) & '1';
	mem_sel <= addr(10 downto 7);
	
	with mem_sel select
	data_out <= data_out0 when "0000",
		data_out1 when "0001",
		data_out2 when "0010",
		data_out3 when "0011",
		data_out4 when "0100",
		data_out5 when "0101",
		data_out6 when "0110",
		data_out7 when "0111",
		data_out8 when "1000",
		data_out9 when "1001",
		data_outA when "1010",
		data_outB when "1011",
		data_outC when "1100",
		data_outD when "1101",
		data_outE when "1110",
		data_outF when "1111",
		(others => '0') when others;
		
	data_in <= "00000000" & t(width-1 downto 0);
	writeF <= write;

	memory0 : RAMB4_S16_S16
		port map (
			addra(7 downto 0) => m_adda(7 downto 0),
			addrb(7 downto 0) => m_addb(7 downto 0),
			dia(15 downto 0) => data_in(15 downto 0),
			dib(15 downto 0) => data_in(31 downto 16),
			doa(15 downto 0) => data_out0(15 downto 0),
			dob(15 downto 0) => data_out0(31 downto 16),
			clka => clk0,
			clkb => clk0,
			wea => clr,
			web => clr,
			ena => aclr,
			enb => aclr,
			rsta => clr,
			rstb => clr);

	memory1 : RAMB4_S16_S16
		port map (
			addra(7 downto 0) => m_adda(7 downto 0),
			addrb(7 downto 0) => m_addb(7 downto 0),
			dia(15 downto 0) => data_in(15 downto 0),
			dib(15 downto 0) => data_in(31 downto 16),
			doa(15 downto 0) => data_out1(15 downto 0),
			dob(15 downto 0) => data_out1(31 downto 16),
			clka => clk0,
			clkb => clk0,
			wea => clr,
			web => clr,
			ena => aclr,
			enb => aclr,
			rsta => clr,
			rstb => clr);

	memory2 : RAMB4_S16_S16
		port map (
			addra(7 downto 0) => m_adda(7 downto 0),
			addrb(7 downto 0) => m_addb(7 downto 0),
			dia(15 downto 0) => data_in(15 downto 0),
			dib(15 downto 0) => data_in(31 downto 16),
			doa(15 downto 0) => data_out2(15 downto 0),
			dob(15 downto 0) => data_out2(31 downto 16),
			clka => clk0,
			clkb => clk0,
			wea => clr,
			web => clr,
			ena => aclr,
			enb => aclr,
			rsta => clr,
			rstb => clr);

	memory3 : RAMB4_S16_S16
		port map (
			addra(7 downto 0) => m_adda(7 downto 0),
			addrb(7 downto 0) => m_addb(7 downto 0),
			dia(15 downto 0) => data_in(15 downto 0),
			dib(15 downto 0) => data_in(31 downto 16),
			doa(15 downto 0) => data_out3(15 downto 0),
			dob(15 downto 0) => data_out3(31 downto 16),
			clka => clk0,
			clkb => clk0,
			wea => clr,
			web => clr,
			ena => aclr,
			enb => aclr,
			rsta => clr,
			rstb => clr);

	memory4 : RAMB4_S16_S16
		port map (
			addra(7 downto 0) => m_adda(7 downto 0),
			addrb(7 downto 0) => m_addb(7 downto 0),
			dia(15 downto 0) => data_in(15 downto 0),
			dib(15 downto 0) => data_in(31 downto 16),
			doa(15 downto 0) => data_out4(15 downto 0),
			dob(15 downto 0) => data_out4(31 downto 16),
			clka => clk0,
			clkb => clk0,
			wea => clr,
			web => clr,
			ena => aclr,
			enb => aclr,
			rsta => clr,
			rstb => clr);

	memory5 : RAMB4_S16_S16
		port map (
			addra(7 downto 0) => m_adda(7 downto 0),
			addrb(7 downto 0) => m_addb(7 downto 0),
			dia(15 downto 0) => data_in(15 downto 0),
			dib(15 downto 0) => data_in(31 downto 16),
			doa(15 downto 0) => data_out5(15 downto 0),
			dob(15 downto 0) => data_out5(31 downto 16),
			clka => clk0,
			clkb => clk0,
			wea => clr,
			web => clr,
			ena => aclr,
			enb => aclr,
			rsta => clr,
			rstb => clr);

	memory6 : RAMB4_S16_S16
		port map (
			addra(7 downto 0) => m_adda(7 downto 0),
			addrb(7 downto 0) => m_addb(7 downto 0),
			dia(15 downto 0) => data_in(15 downto 0),
			dib(15 downto 0) => data_in(31 downto 16),
			doa(15 downto 0) => data_out6(15 downto 0),
			dob(15 downto 0) => data_out6(31 downto 16),
			clka => clk0,
			clkb => clk0,
			wea => clr,
			web => clr,
			ena => aclr,
			enb => aclr,
			rsta => clr,
			rstb => clr);

	memory7 : RAMB4_S16_S16
		port map (
			addra(7 downto 0) => m_adda(7 downto 0),
			addrb(7 downto 0) => m_addb(7 downto 0),
			dia(15 downto 0) => data_in(15 downto 0),
			dib(15 downto 0) => data_in(31 downto 16),
			doa(15 downto 0) => data_out7(15 downto 0),
			dob(15 downto 0) => data_out7(31 downto 16),
			clka => clk0,
			clkb => clk0,
			wea => clr,
			web => clr,
			ena => aclr,
			enb => aclr,
			rsta => clr,
			rstb => clr);

	memory8 : RAMB4_S16_S16
		port map (
			addra(7 downto 0) => m_adda(7 downto 0),
			addrb(7 downto 0) => m_addb(7 downto 0),
			dia(15 downto 0) => data_in(15 downto 0),
			dib(15 downto 0) => data_in(31 downto 16),
			doa(15 downto 0) => data_out8(15 downto 0),
			dob(15 downto 0) => data_out8(31 downto 16),
			clka => clk0,
			clkb => clk0,
			wea => clr,
			web => clr,
			ena => aclr,
			enb => aclr,
			rsta => clr,
			rstb => clr);

	memory9 : RAMB4_S16_S16
		port map (
			addra(7 downto 0) => m_adda(7 downto 0),
			addrb(7 downto 0) => m_addb(7 downto 0),
			dia(15 downto 0) => data_in(15 downto 0),
			dib(15 downto 0) => data_in(31 downto 16),
			doa(15 downto 0) => data_out9(15 downto 0),
			dob(15 downto 0) => data_out9(31 downto 16),
			clka => clk0,
			clkb => clk0,
			wea => clr,
			web => clr,
			ena => aclr,
			enb => aclr,
			rsta => clr,
			rstb => clr);

	memoryA : RAMB4_S16_S16
		port map (
			addra(7 downto 0) => m_adda(7 downto 0),
			addrb(7 downto 0) => m_addb(7 downto 0),
			dia(15 downto 0) => data_in(15 downto 0),
			dib(15 downto 0) => data_in(31 downto 16),
			doa(15 downto 0) => data_outA(15 downto 0),
			dob(15 downto 0) => data_outA(31 downto 16),
			clka => clk0,
			clkb => clk0,
			wea => clr,
			web => clr,
			ena => aclr,
			enb => aclr,
			rsta => clr,
			rstb => clr);

	memoryB : RAMB4_S16_S16
		port map (
			addra(7 downto 0) => m_adda(7 downto 0),
			addrb(7 downto 0) => m_addb(7 downto 0),
			dia(15 downto 0) => data_in(15 downto 0),
			dib(15 downto 0) => data_in(31 downto 16),
			doa(15 downto 0) => data_outB(15 downto 0),
			dob(15 downto 0) => data_outB(31 downto 16),
			clka => clk0,
			clkb => clk0,
			wea => clr,
			web => clr,
			ena => aclr,
			enb => aclr,
			rsta => clr,
			rstb => clr);

	memoryC : RAMB4_S16_S16
		port map (
			addra(7 downto 0) => m_adda(7 downto 0),
			addrb(7 downto 0) => m_addb(7 downto 0),
			dia(15 downto 0) => data_in(15 downto 0),
			dib(15 downto 0) => data_in(31 downto 16),
			doa(15 downto 0) => data_outC(15 downto 0),
			dob(15 downto 0) => data_outC(31 downto 16),
			clka => clk0,
			clkb => clk0,
			wea => clr,
			web => clr,
			ena => aclr,
			enb => aclr,
			rsta => clr,
			rstb => clr);

	memoryD : RAMB4_S16_S16
		port map (
			addra(7 downto 0) => m_adda(7 downto 0),
			addrb(7 downto 0) => m_addb(7 downto 0),
			dia(15 downto 0) => data_in(15 downto 0),
			dib(15 downto 0) => data_in(31 downto 16),
			doa(15 downto 0) => data_outD(15 downto 0),
			dob(15 downto 0) => data_outD(31 downto 16),
			clka => clk0,
			clkb => clk0,
			wea => clr,
			web => clr,
			ena => aclr,
			enb => aclr,
			rsta => clr,
			rstb => clr);

	memoryE : RAMB4_S16_S16
		port map (
			addra(7 downto 0) => m_adda(7 downto 0),
			addrb(7 downto 0) => m_addb(7 downto 0),
			dia(15 downto 0) => data_in(15 downto 0),
			dib(15 downto 0) => data_in(31 downto 16),
			doa(15 downto 0) => data_outE(15 downto 0),
			dob(15 downto 0) => data_outE(31 downto 16),
			clka => clk0,
			clkb => clk0,
			wea => clr,
			web => clr,
			ena => aclr,
			enb => aclr,
			rsta => clr,
			rstb => clr);

	memoryF : RAMB4_S16_S16
		port map (
			addra(7 downto 0) => m_adda(7 downto 0),
			addrb(7 downto 0) => m_addb(7 downto 0),
			dia(15 downto 0) => data_in(15 downto 0),
			dib(15 downto 0) => data_in(31 downto 16),
			doa(15 downto 0) => data_outF(15 downto 0),
			dob(15 downto 0) => data_outF(31 downto 16),
			clka => clk0,
			clkb => clk0,
			wea => writeF,
			web => writeF,
			ena => aclr,
			enb => aclr,
			rsta => clr,
			rstb => clr);

	sum <= (('0'&t(width-1 downto 0)) + ('0'&s(width-1 downto 0)));

	with t_sel select
	t_in <= (not t) when not_t,
		(t xor s) when s_xor_t,
		(t and s) when s_and_t,
		sum when sum_t,
		(t(width-1 downto 0) & '0') when shl_t,
		(t(width-1 downto 0) & a(width-1)) when shl_t_a_t,
		(sum(width-1 downto 0) & a(width-1)) when shl_sum_a_t,
		('0'&sum(width downto 1)) when shr_sum,
		(uart_in&t(width-1)&t(width-1 downto 1)) when shr_t,
		("00"&t(width-1 downto 1)) when shr_t_t,
		s when s_t,
		a when a_t,
		r when r_t,
		'0'&data_out(width-1 downto 0) when others;

	with slot select
	code <= i(23 downto 18) when 1,
		i(17 downto 12) when 2,
		i(11 downto 6) when 3,
		i(5 downto 0) when 4,
		nop when others;
	icode <= code;

	a_in <= a+1 when a_sel=a1_a else
		('0'&t(0)&a(width-1 downto 1)) when a_sel=shr_t_a else
		('0'&sum(0)&a(width-1 downto 1)) when a_sel=shr_sum_a else
		('0'&a(width-2 downto 0)&sum(width)) when a_sel=shl_sum_a else
		t ;

	r_in <= r+1 when r_sel=r1_r else
		p when r_sel=p_r else
		t ;

	p_in <= (p(width downto 19) & i(18 downto 0)) when p_sel=pi_p else
		r when p_sel=r_p else
		("00000000000000000000"&interrupt(4 downto 0)) when p_sel=int_p else
		p+1;

	addr <= a(10 downto 0) when addr_sel=a_addr else
		p(10 downto 0);


	z <= not(t(23) or t(22) or t(21) or t(20)
		or t(19) or t(18) or t(17) or t(16)
		or t(15) or t(14) or t(13) or t(12)
		or t(11) or t(10) or t(9) or t(8)
		or t(7) or t(6) or t(5) or t(4)
		or t(3) or t(2) or t(1) or t(0));

-- sequential assignments, with slot and code		
	decode: process(code,z,t,slot,sum,p,i,
			sp,sp1,rp,rp1) begin
		t_sel<="0000"; 
		a_sel<="000";
		p_sel<="000";
		r_sel<="00";
		spush<='0'; 
		spopp<='0';
		rpush<='0'; 
		rpopp<='0'; 
		tload<='0'; 
		aload<='0';
		pload<='0'; 
		addr_sel<="000"; 
		write<='0'; 
		iload<='0';
		reset<='0';

	if slot=0 then
		if interrupt/="00000" then
			pload<='1';
			p_sel<=int_p;--process interrupts
			rpush<='1'; 
			r_sel<=p_r;
			reset<='1';		
		else	iload<='1';
			p_sel<=p1_p;--fetch next word
			pload<='1';
		end if;
	else
	case code is
		when jmp =>
			pload<='1';
			p_sel<=pi_p;
			reset<='1';
		when ret => pload<='1'; 
			p_sel<=r_p;
			rpopp<='1';
			reset<='1';
		when jz => 
			if Z='1' then
				pload<='1';
				p_sel<=pi_p;
			end if;
			tload<='1';
			t_sel<=s_t; 
			spopp<='1'; 
			reset<='1';
		when jnc => 
			if t(width)='0' then
				pload<='1';
				p_sel<=pi_p;
			end if;
			reset<='1';
		when call => 
			pload<='1';
			p_sel<=i_p;--process call
			rpush<='1'; 
			r_sel<=p_r;
			reset<='1';
		when ldp => addr_sel<=a_addr; 
			a_sel<=a1_a;
			aload<='1'; 
			tload<='1';
			t_sel<=data_t; 
			spush<='1'; 
		when lit => pload<='1'; 
			p_sel<=p1_p;
			tload<='1';
			t_sel<=data_t; 
			spush<='1'; 
		when ld => addr_sel<=a_addr; 
			tload<='1';
			t_sel<=data_t; 
			spush<='1'; 
		when stp => addr_sel<=a_addr; 
			aload<='1'; 
			a_sel<=a1_a;
			tload<='1';
			t_sel<=s_t; 
			spopp<='1'; 
			write<='1'; 
		when st => addr_sel<=a_addr; 
			tload<='1';
			t_sel<=s_t; 
			spopp<='1'; 
			write<='1'; 
		when com => 
			tload<='1';
			t_sel<=not_t; 
		when shl => 
			tload<='1';
			t_sel<=shl_t; 
		when shr => 
			tload<='1';
			t_sel<=shr_t; 
			uload<='1';
		when mul => 
			aload<='1';
			tload<='1';
			if a(0)='1' then
				t_sel<=shr_sum;
				a_sel<=shr_sum_a;
			else	t_sel<=shr_t_t;
				a_sel<=shr_t_a;
			end if;
		when xorr => 
			tload<='1';
			t_sel<=s_xor_t; 
			spopp<='1';
		when andd => 
			tload<='1';
			t_sel<=s_and_t; 
			spopp<='1';
		when div => 
			aload<='1';
			tload<='1';
			a_sel<=shl_sum_a;
			if sum(width)='1' then
				t_sel<=shl_sum_a_t;
			else	t_sel<=shl_t_a_t;
			end if;
		when addd => 
			tload<='1';
			t_sel<=sum_t; 
			spopp<='1';
		when pop => 
			tload<='1';
			t_sel<=r_t; 
			spush<='1';
			rpopp<='1';
		when lda => 
			tload<='1';
			t_sel<=a_t; 
			spush<='1';
		when dup => 
			spush<='1';
		when push => 
			tload<='1';
			t_sel<=s_t; 
			rpush<='1';
			r_sel<=t_r;
			spopp<='1';
		when sta => 
			tload<='1';
			t_sel<=s_t; 
			a_sel<=t_a;
			aload<='1'; 
			spopp<='1';
		when nop => reset<='1';
		when drop => 
			tload<='1';
			t_sel<=s_t; 
			spopp<='1';
		when others => null;
	end case;
	end if;
	end process decode;

-- finite state machine, processor control unit	
	sync: process(clk,clr) begin
		if clr='1' then -- master reset
			slot <= 0;
			sp  <= 0;
			sp1 <= 1;
			rp  <= 0;
			rp1 <= 1;
			t <= (others => '0');
			a <= (others => '0');
			p <= (others => '0');
			i <= (others => '0');
			for ii in s_stack'range loop
				s_stack(ii) <= (others => '0');
				r_stack(ii) <= (others => '0');
			end loop;
		elsif (clk'event and clk='1') then
			if reset='1' or slot=4 then
				slot <= 0;
			else	slot <= slot+1;
			end if;
			if iload='1' then
				i <= '0'&data_out(width-1 downto 0);
			end if;
			if pload='1' then
				p <= p_in;
			end if;
			if tload='1' then
				t <= t_in;
			end if;
			if aload='1' then
				a <= a_in;
			end if;
			if spush='1' then
				s_stack(sp1) <= t;
				sp <= sp+1;
				sp1 <= sp1+1;
			elsif spopp='1' then
				sp <= sp-1;
				sp1 <= sp1-1;
			end if;
			if rpush='1' then
				r_stack(rp1) <= r_in;
				rp <= rp+1;
				rp1 <= rp1+1;
			elsif rpopp='1' then
				rp <= rp-1;
				rp1 <= rp1-1;
			end if;
			if uload='1' then
				uart_out<=t(0);
				t(width)<=uart_in;
			end if;
		end if;
	end process sync;

end archcpu24;



