ONLY FORTH ALSO SIM24 DEFINITIONS

( eM24 Simulator, 21jun00cht )
( derived from P16.txt 06jun99cht)
( 02sep00cht, eliminate R, X, Y registers)
( SIM25.seq, ok for ef24 )
( SIM26, 29oct00cht, move to win32forth )
( sim24, 09nov00cht, for P24 )
( sim24b.f, 27nov00cht, align to sim26f.f with get and put)
( 30nov00cht, change to P24, 6 bit instrucitons )

DECIMAL

15 CONSTANT LIMIT       ( stack depth )
$1FFF CONSTANT RANGE   ( size of memory array )
VARIABLE CLOCK          ( slot is in the last 3 bits )
VARIABLE (REGISTER)     ( where registers and stacks are )
VARIABLE BREAK          ( address of break point )

( On the rising edge of clock, copy TO array to FROM array. )
: REGISTER  (REGISTER) @ ;
: FROM  PAD (REGISTER) ! ;
: TO    PAD $180 + (REGISTER) ! ;

: P     REGISTER ;
: T     REGISTER 4 + ;
: R     REGISTER 8 + ;
: A     REGISTER 12 + ;
: I     REGISTER 24 + ;
: I0    REGISTER 28 + ;
: I1    REGISTER 29 + ;
: I2    REGISTER 30 + ;
: I3    REGISTER 31 + ;
: I4    REGISTER 32 + ;
: RP    REGISTER 33 + ;
: SP    REGISTER 34 + ;
: RSTACK  RP C@ LIMIT AND CELLS REGISTER + $40 + ;
: SSTACK  SP C@ LIMIT AND CELLS REGISTER + $80 + ;

: CYCLE TO P FROM P $180 CMOVE 1 CLOCK +! ;

: NEXT  CLOCK @ 7 OR CLOCK ! ;

: RPUSH ( d -- , push d on return stack )
        FROM R @ RP C@ 1 + LIMIT AND TO RP C! RSTACK ! R ! ;

: RPOPP ( -- d , pop d from return stack )
        FROM R @ RSTACK @ RP C@ 1 - LIMIT AND TO RP C! R ! ;

: SPUSH ( d -- , push d on data stack )
        FROM T @ SP C@ 1 + LIMIT AND TO SP C! SSTACK ! T ! ;

: SPOPP ( -- d , pop d from data stack )
        FROM T @ SSTACK @ SP C@ 1 - LIMIT AND TO SP C! T ! ;

: continue
        FROM P @ DUP 1+ TO RANGE AND P !
        RAM@ DUP I !
        64 /MOD SWAP I4 C!
        64 /MOD SWAP I3 C!
        64 /MOD SWAP I2 C!
        63 AND I1 C!
        ;

: jmp   FROM I @ RANGE AND TO P ! NEXT ;
: call  FROM P @ RPUSH jmp ;
: ret   RPOPP TO RANGE AND P !
        NEXT ;
: jz    SPOPP $FFFFFF AND IF NEXT EXIT THEN
        jmp ;
: jnc   FROM T @ $1000000 AND IF NEXT EXIT THEN
        jmp ;
: ld    FROM A @ RANGE AND RAM@ SPUSH ;
: ldp   ld
        FROM A @ 1+ TO A ! ;
: ldi   FROM P @ 1+ RANGE AND TO P !
        FROM P @ RANGE AND RAM@ SPUSH ;
: st    SPOPP FROM A @ RANGE AND RAM! ;
: stp   st
        FROM A @ 1+ TO A ! ;
: com   FROM T @ $FFFFFF AND $FFFFFF XOR TO T ! ;
: shr   FROM T @ 2/ $FFFFFF AND TO T ! ;
: shl   FROM T @ 2* $1FFFFFF AND TO T ! ;
: mul   FROM A @ 1 AND
        IF SSTACK @ T @ + $1FFFFFF AND
        ELSE T @ THEN
        DUP 1 AND >R 2/ TO T !
        FROM A @ $FFFFFF AND 2/ R> IF $800000 OR THEN TO A ! ;
: andd  SPOPP TO T @ AND $FFFFFF AND T ! ;
: xorr  SPOPP TO T @ XOR $FFFFFF AND T ! ;
: div   FROM SSTACK @ $FFFFFF AND T @ $FFFFFF AND +
        DUP $1000000 AND DUP >R
        IF ELSE DROP T @ THEN $FFFFFF AND
        2* ( diff) A @ $800000 AND IF 1+ THEN TO T !
        FROM A @ 2* $FFFFFF AND R> IF 1+ THEN TO A ! ;
: add   SPOPP $FFFFFF AND TO T @ $FFFFFF AND + TO T ! ;
: popr  RPOPP SPUSH ;
: pushs FROM T @ SPUSH ;
: lda   FROM A @ SPUSH ;
: pushr SPOPP RPUSH ;
: sta   SPOPP TO A ! ;
: pops  SPOPP DROP ;
: nop   NEXT ;
: get   KEY DUP $1B = ABORT" done"
        SPUSH ret ;
: put   SPOPP $7F AND EMIT ret ;

HEX

: execute ( code -- )
        DUP  0 = IF DROP jmp  EXIT THEN
        DUP  1 = IF DROP ret  EXIT THEN
        DUP  2 = IF DROP jz   EXIT THEN
        DUP  3 = IF DROP jnc  EXIT THEN
        DUP  4 = IF DROP call EXIT THEN
        DUP  6 = IF DROP get  EXIT THEN
        DUP  7 = IF DROP put  EXIT THEN
        DUP  9 = IF DROP ldp  EXIT THEN
        DUP 0B = IF DROP ld   EXIT THEN
        DUP 0A = IF DROP ldi  EXIT THEN
        DUP 0D = IF DROP stp  EXIT THEN
        DUP 0F = IF DROP st   EXIT THEN
        DUP 10 = IF DROP com  EXIT THEN
        DUP 11 = IF DROP shl  EXIT THEN
        DUP 12 = IF DROP shr  EXIT THEN
        DUP 13 = IF DROP mul  EXIT THEN
        DUP 14 = IF DROP xorr EXIT THEN
        DUP 15 = IF DROP andd EXIT THEN
        DUP 16 = IF DROP div  EXIT THEN
        DUP 17 = IF DROP add  EXIT THEN
        DUP 18 = IF DROP popr EXIT THEN
        DUP 19 = IF DROP lda  EXIT THEN
        DUP 1A = IF DROP pushs EXIT THEN
        DUP 1C = IF DROP pushr EXIT THEN
        DUP 1D = IF DROP sta  EXIT THEN
        DUP 1E = IF DROP nop  EXIT THEN
        DUP 1F = IF DROP pops EXIT THEN
        CR . ." illegal code" ABORT
        ;

: .stack ( add # ) 0 ?DO DUP @ . 4 - LOOP DROP CR ;
: .sstack ." S:" T @ . SSTACK SP C@ .stack ;
: .rstack ." R:" R @ . RSTACK RP C@ .stack ;
: .registers ."  P=" P @ . ."  I=" I @ .
        ." I1=" I1 C@ . ." I2=" I2 C@ .
        ." I3=" I3 C@ . ." I4=" I4 C@ . CR
        ." A=" A @ . CR ;
: S  CR ." CLOCK=" CLOCK @ . .registers
        .sstack .rstack ;

: sync  CLOCK @ 7 AND
        DUP 0 = IF   continue DROP EXIT THEN
        DUP 1 = IF   I1 C@ execute DROP EXIT
                THEN
        DUP 2 = IF   I2 C@ execute DROP EXIT
                THEN
        DUP 3 = IF   I3 C@ execute DROP EXIT
                THEN
        DUP 4 = IF   I4 C@ execute THEN
        DROP NEXT ;
: C     sync CYCLE S ;
: reset FROM P 300 ERASE 0 CLOCK ! ;
reset

: G     ( addr -- )
        CR ." Press any key to stop." CR
        BREAK !
        BEGIN sync P @ BREAK @ =
              IF CYCLE C EXIT
              ELSE CYCLE
              THEN
              KEY?
        UNTIL ;
: PUSH  ( d ) pushs TO T ! ;
: POP   pops ;

: D     P @ 1- FOUR FOUR ;
: M     SHOW ;
: RUN   CR ." Press ESC to stop." CR
        BEGIN C KEY 1B = UNTIL ;
: P     RANGE AND DUP FROM P ! TO P ! ;

: HELP  CR ." eM24 Simulator, copyright eMAST Technology, 2000"
        CR ." C: execute next cycle"
        CR ." S: show all registers"
        CR ." D: display next 8 words"
        CR ." addr M: display 128 words from addr"
        CR ." addr P: start execution at addr"
        CR ." addr G: run and stop at addr"
        CR ." RUN: execute, one key per cycle"
        CR ;

( patch KEY and EMIT to run eForth interactively )
180000 B7 RAM!
1C0000 AA RAM!
