( EPROM Programmer, Chuck Moore, 1993 Aug 16)
( modified from ok28 for P16, 08dec98cht )
( 29nov00cht, P24, 6 bit fields )

ONLY FORTH ALSO ASM24
ASM24 DEFINITIONS

VARIABLE H
: LOC   CONSTANT  DOES> @  H ! ;

variable lastH 0 lastH !        \ init linkfield address lfa

: nameR! ( n -- )
   H @ RAM!                     \ store double to code buffer
   1 H +!                       \ bump nameH
   ;

: compile-only 400000 lastH @ RAM@ -OR lastH @ RAM! ;
: immediate    800000 lastH @ RAM@ -OR lastH @ RAM! ;

\ Derived from Chuck Moore's P21 20 bit assembler

VARIABLE Hi   VARIABLE Hw
VARIABLE Bi ( for packing)

: ALIGN  10 Hi ! ;
: ORG    DUP . CR H !  ALIGN ;
: SWITCH H @  SWAP  ORG ;
: IS     H @  Hi @ 10 / +  CONSTANT ;
: ALLOT ( n -- ) H +! ;

CREATE mask  FC0000 ,  3F000 ,  FC0 ,  3F ,
: #,     FFFFFF AND H @ RAM!  1 H +! ;
: ,w     Hw @ RAM@  -OR  FFFFFF AND Hw @ RAM! ;
: ,I     Hi @ 10 AND IF  0 Hi !  H @ Hw !  0 #,  THEN
         Hi @ mask + @ AND  ,w  4 Hi +! ;
: ,B   ( c ) Bi @ 0 = IF 1 Bi ! H @ Hw ! 0 #, 10000 * ,w EXIT THEN
             Bi @ 1 = IF 2 Bi ! 100 * ,w EXIT THEN
             0 Bi ! ,w ;

: INST   CONSTANT   DOES> @  ,I ;
79E79E INST nop
: anew   BEGIN Hi @ 10 AND 0= WHILE nop REPEAT 0 Bi !
         H @ Hw ! ;
: JMP    CONSTANT  DOES> @  anew SWAP 3FFFF AND -OR #, ALIGN ;
: begin  anew  H @ ;
: -;'    Hw @ RAM@ DUP $FC0000 AND 100000 =
         IF 100000 -OR Hw @ RAM! ELSE DROP THEN ;
: ldi    28A28A ,I  #, ;
: FIX    DROP 1 - >R  begin  R> RAM! ;

100000 JMP call

0 JMP jump   80000 JMP bz    C0000 JMP bnc
             80000 JMP until  C0000 JMP -until
: if     begin 0 bz ;
: -if    begin 0 bnc ;
: skip   begin 0 jump ;
: then   DUP >R >R  begin  3FFFF AND  R> RAM@ -OR  R> RAM! ;
: else   skip SWAP then ;
: while   if  SWAP ;
: -while -if  SWAP ;
: repeat jump then ;
: again  jump ;
                 41041 INST ret
249249 INST ldp   2CB2CB INST ld    34D34D INST stp   3CF3CF INST st
410410 INST com   451451 INST shl   492492 INST shr   4D34D3 INST mul
514514 INST xor   555555 INST and   596596 INST div   5D75D7 INST add
618618 INST pop   659659 INST lda   69A69A INST dup
71C71C INST push  75D75D INST sta ( 79E79E INST nop ) 7DF7DF INST drop

: pops drop ;
: pushs dup ;

: ljump  ' >body @ ldi           \ get address of target word
   push  ret ;                    \ long jump

: (makeHead)
   anew
   20 word                      \ get name of new definition
   lastH @ nameR!               \ fill link field of last word
   H @ lastH !                  \ save nfa in lastH
   forthdup c@ ,B                \ store count
   count 0 do
      count ,B              \ fill name field
   loop forthdrop anew
   ;

: makeHead
   >IN @ >R                     \ save interpreter pointer
   (makeHead)
   R> >IN !                     \ restore word pointer
   ;

: $LIT ( -- )
   anew
   22 WORD
   forthDUP c@ ,B ( compile count )
   count 0 DO
      count ,B ( compile characters )
   LOOP
   forthDROP anew ;

: ':     begin  .head CONSTANT  DOES> @  call ;
: CODE makeHead ': ;
: :: CODE ;

cr

