
comment:
meta.seq, meta-compiler for eForth high level words, 04feb95cht
meta28.seq, MuP21h with 82C51 serial chip, 14mar96cht
   Add RECTANGLE to ok28c.seq, 19mar96cht
meta24.seq, 26jun00cht, modified for em24
meta24e4.seq, 19sep00cht, COLD and CR worked.
meta24e5.seq, 20sep00cht, says OK.
meta24e6.seq, 15oct00cht, test extended DIAGNOSE
meta24e7.seq, 15oct00cht, fix RECURSE, $,n and COLD. test system
meta26.f, 26oct00cht, move to win32f
meta26a.  31oct00cht, DIAGNOSE ok.
meta24.f  07nov00cht, change for P24, p24c
          02dec00cht, interpreter ok, debugging compiler
p24e      13dec00cht, add write-log-file to save mif file

comment;

VOCABULARY ASM24
VOCABULARY SIM24

ONLY FORTH ALSO DEFINITIONS

HEX
WARNING OFF
' NOOP IS STACK-CHECK

variable debugging?
debugging? off

: .head ( addr -- addr )
   >IN @ 20 word count type space >IN !
   dup .
   ;

: CR CR
   debugging? @
   if .s KEY 0D = abort" done"
   then
   ;

' '      alias forth'
' dup    alias forthDUP
' drop   alias forthDROP
' over   alias forthOVER
' swap   alias forthSWAP
' @      alias forth@
' !      alias forth!
' and    alias forthAND
' +      alias forth+
' -      alias forth-
' word   alias forthWORD
' CR     alias CRR
' .(     alias forth.(
' count  alias forthCOUNT

: -OR   XOR ;

CREATE ram  8000 ALLOT
: RESET   ram 8000 ERASE ;   RESET
: RAM@   4 * ram +  @ ;
: RAM!   4 * ram +  ! ;

: FOUR   4 0 DO  DUP RAM@ 7 U.R  1+ LOOP ;
: SHOW ( a)   10 0 DO  CR  DUP 7 .R SPACE
      FOUR SPACE FOUR  LOOP ;
: showram 0 0c 0 do show loop drop ;

: ud. 0 <# # # # # # # # # #> type ;
: b.  0 <# # # #> type ;
: c.  0 <# # #> type ;
: string. ( a ) 8 / 10 /mod swap
\        ." attribute INIT_" b.
        ."  qq" b.
        ."  of memory" 0F and c.
        ." :label is " 22 emit ;
: eight   8 + dup 8 0 DO  1 - DUP RAM@ ud.  LOOP DROP ;
: blockram ( a)   10 0 DO  CR DUP string.
      eight 22 emit 3B emit LOOP cr ;
: BRAM base @ hex 0 0F 0 do blockram loop drop base ! ;

: ubd. 0 <# $18 0 do # loop #> type cr ;
: bdump base @ binary cr
   $800 0 do i ram@ ubd. loop
   base ! ;

variable file-id
: write-log-file
   s" log.f" r/w open-file
   abort" create file error"
   file-id !
   base @ binary
   800 0 do
      i ram@ 0 <# 0d hold 18 0 do # loop #> file-id @ write-file
      abort" write file error"
   loop
   base !
   file-id @ close-file
   abort" close file error"
   ;

CR .( include asm24 )
include ok24

$18 org
CR .( include eforth kernel )
include kern24

: again ( a -- )
   jump ;
: for ( -- a )
   push begin ;
: next ( a -- )
   doNEXT jump ;
: <next> next ;
: aft ( a -- a' a" )
   forthDROP begin 0 jump begin forthSWAP ;
: LIT ( d -- )
   ldi ;
: $LIT ( -- )
   22 forthWORD forthCOUNT
   forthDUP ,B ( compile count )
   0 DO
      forthCOUNT ,B ( compile characters )
   LOOP
   forthDROP ;

' EXIT alias ;;
\ ' WAIT alias ;;               \ debugger

: CREATE makeHead begin .head CONSTANT doVAR DOES> forth@ call ;
: VARIABLE CREATE 0 #, ;       

CR .( include eforth24 )
include ef24

CR
0 ORG
10 LIT 704 LIT 6 LIT
forth' COLD >body forth@ LIT
push push
anew H forth@
   push sta ldp push
   lda pop pop sta
   stp lda
<next>
pops pops ret

10 ORG
730 #,
0A #,
lastH forth@ #,
780 #,
lastH forth@ #,
forth' $INTERPRET >body forth@ #,
forth' QUIT >body forth@ #,

