\ eForth Kernel for P16, 02dec98cht
\ from kernel28.seq, comment out debugging aids, 24nov95cht
\    Keep 0 page usage to 2FF.  300-3FF needed by system.
\ kern16 10jun88cht
\ kern24, 29nov00cht, for P24, 'if' does drop. add B> and >B for packing bytes.

comment:

The Forth Virtual Engine is:
   T              top of stack
   S              data stack     16 levels
   R              return stack   16 levels
Both the data and return stacks are in CPU.

Subroutine thread model eliminates IP.

16 levels of stacks are enough for most applications.  They will
wrap around when exhausted.

Memory allocation:
        0       Boot code
        10      Initial variables
        18      Kernel
        9A      Forth words
        700     RAM, variables
        710     Text buffer
        730     TIB
        780     User dictionary
        7FF     End of memory

'if' drops top element being tested.
'-if' does not drop, as it tests carry.
comment;

hex
CRR .( System variables ) CRR
: HLD 700 ldi ;         \ scratch
: SPAN 701 ldi ;        \ #chars input by EXPECT
: >IN  702 ldi ;        \ input buffer offset
: #TIB 703 ldi ;        \ #chars in the input buffer
: 'TIB 704 ldi ;        \ TIB
: BASE 705 ldi ;       \ number base

CRR
: CONTEXT 706 ldi ;    \ first search vocabulary
: CP 707 ldi ;         \ dictionary code pointer
: LAST 708 ldi ;       \ ptr to last name compiled
: 'EVAL 709 ldi ;       \ interpret/compile vector
: 'ABORT 70A ldi ;
: TEXT 710 ldi ;         \ unpack buffer
: tmp 70B ldi ;        \ ptr to converted # string

CR .( macro words ) CR
: EXIT ret ;
: EXECUTE ( a ) push ret ;
: ! ( n a -- ) sta st ;
: @ ( a - n ) sta ld ;
: R> ( - n ) pop ;
: R@ ( - n ) pop dup push ;
: >R ( n ) push ;
: SWAP ( n1 n2 - n2 n1 )
   push sta pop lda ;
: OVER ( n1 n2 - n1 n2 n1 )
   push dup sta pop
   lda ;
: 2DROP ( w w  -- )
   drop drop ;
: + ( w w -- w ) add ;
: NOT ( w -- w ) com ;
:  NEGATE ( n -- -n )
   com 1 ldi add ;
: 1- ( a -- a )
   -1 ldi add ;
: 1+ ( a -- a )
   1 ldi add ;
: BL ( -- 32 )
   20 ldi ;
: +! ( n a -- )
   sta ld add st
   ;
: - ( w w -- w )
   com add 1 ldi add
   ;

CR .( kernel words ) CR
CODE doVAR
   pop ret
CODE doLIT
   pop sta ldp
   lda push ret
CODE doNEXT
   pop pop dup                \ decrement count
   if -1 ldi add push
      push ret             \ if index is not 0, loop back
   then
   drop 1 ldi add                  \ index is 0, exit loop and continue
   push ret

CR
CODE 0< ( n - f )
   shl
   -if drop -1 ldi ret
   then
   dup xor ( 0 ldi )
   ret
CODE OR ( n n - n )
   com push com
   pop and com ret
CODE UM+  ( n n - n carry )
   add
   -if 1 ldi ret
   then
   dup dup xor ( 0 )
   ret
CODE ?DUP ( w -- w w | 0 )
   dup
   if dup ret then
   ret
CODE ROT ( w1 w2 w3 -- w2 w3 w1 )
   push push sta pop
   pop lda ret
CODE 2DUP ( w1 w2 -- w1 w2 w1 w2 )
   dup push push
   dup sta pop lda pop
   ret

CR
CODE DNEGATE ( d -- -d )
   com push com 1 ldi
   add
   -if pop ret
   then
   pop 1 ldi add ret
CODE ABS ( n -- +n )
   dup shl
   -if drop com 1 ldi add
       ret
   then
   drop ret

CR
CODE = ( w w -- t )
   xor
   if dup dup xor ret then
   -1 ldi ret
CODE 2! ( d a -- )
   sta push stp
   pop st ret
CODE 2@ ( a -- d )
   sta ldp ld ret
CODE COUNT ( b -- b +n )
   sta ldp push lda
   pop ret

CR ( pack B> and unpack >B strings )
CODE B> ( b a -- b+1 a )
   push sta ldp push
   lda pop pop sta
   ld 
   shl shl shl shl
   shl shl shl shl 
   add st lda ret
CODE >B ( a b -- a+1 b+3 count )
   push sta ldp push
   lda pop pop ( a+1 n b ) sta 
   dup push 
   $FF ldi and pop
   $FFFF00 ldi and $FF ldi xor
   shr shr shr shr
   shr shr shr shr
   dup push 
   $FF ldi and pop 
   $FFFF00 ldi and $FF ldi xor
   shr shr shr shr
   shr shr shr shr
   $FF ldi and dup push
   stp stp stp ( a+1 c )
   lda pop ret

