( Copyrighted by eMAST Technology Corp, 2000 )
( All rights reserved )

comment:
\ eForth.seq, adapted from Bill Muench's aFIG.b, 27feb96cht
\ V2.06, slow down I/O for stability of RS232, 11/nov95cht
\ V2.07, merge rectangle routine in hline27, 24nov95cht
\ V20.8, add RECTANGLE to ok28c.seq, add space to 'redef ',
\        use 82C51 for serial communication. 18mar96cht
\ ef24.f 07nov00cht, convert to P24
\        02dec00cht, says ok, check DUMP, .S, WORDS and SEE

This implementation follows closely the eForth model.  The
following set of words are removed because they are not absolutely
necessary for embedded applications.  In this implementation,
the size constrain is severe, and the existence of every word
must be justified rigorously.

Words removed from the eForth model:
        CATCH, THROW, PRESET, XIO, FILE, HAND, I/O
        CONSOLE, RECURSE, USER, VER, HI, 'BOOT

Most of the user variables are eliminated:
        SP0, RP0, '?KEY, 'EMIT, 'EXPECT, 'TAP, 'ECHO
        'PROMPT, CSP, 'NUMBER, HANDLER, CURRENT, NP

Only these user variables remain and are macros:
        HLD, >IN, #TIB, 'TIB, 'EVAL, BASE, tmp
        CP, CONTEXT, LAST, 'ABORT

comment;

CRR .( Chararter IO ) CRR
CODE 50us
        2 ldi skip
CODE 100us
        1 ldi
        then
        sta $-89 ldi
        begin lda add
        -until
        drop
        ret
CODE EMIT ( c -- )
        $FF ldi and
        shl $FFFE00 ldi xor
        $0B ldi
        FOR shr 100us NEXT
        drop ret
CODE KEY ( -- c )
        $FFFFFF ldi
        begin   shr
        -while    ( wait for start bit )
        repeat
        50us
        7 ldi
        FOR
          100us shr
          -if else $80 ldi xor then
        NEXT
        $FF ldi and
        100us -;'

CRR .( Common functions ) CRR
:: U< ( u u -- t ) 2DUP XOR 0< IF SWAP DROP 0< EXIT THEN - 0< -;'
::  < ( n n -- t ) 2DUP XOR 0< IF      DROP 0< EXIT THEN - 0< -;'
:: MAX ( n n -- n ) 2DUP      < IF SWAP THEN DROP ;;
:: MIN ( n n -- n ) 2DUP SWAP < IF SWAP THEN DROP ;;
:: WITHIN ( u ul uh -- t ) \ ul <= u < uh
  OVER - >R - R> U< -;'

CRR .( Divide ) CRR
CODE UM/MOD ( ud u -- ur uq )
   com 1 ldi add sta
   push lda push sta
   pop pop
   skip
CODE /MOD ( n n -- r q )
   com 1 ldi add push
   sta pop 0 ldi
   then
   div div div div
   div div div div
   div div div div
   div div div div
   div div div div
   div div div div
   div 1 ldi xor shr
   push drop pop lda
   ret
CODE MOD ( n n -- r )
   /MOD
   drop ret
CODE / ( n n -- q )
   /MOD
   push drop pop ret
:: M/MOD ( d n -- r q ) \ floored
  DUP 0<  DUP >R
  IF NEGATE >R DNEGATE R>
  THEN >R DUP 0< IF R@ + THEN R> UM/MOD R>
  IF SWAP NEGATE SWAP THEN ;;

CRR .( Multiply ) CRR
CODE UM* ( u u -- ud )
   sta 0 ldi
   mul mul mul mul
   mul mul mul mul
   mul mul mul mul
   mul mul mul mul
   mul mul mul mul
   mul mul mul mul
   push drop lda pop
   ret
:: * ( n n -- n ) UM* DROP ;;
:: M* ( n n -- d )
  2DUP XOR 0< >R  ABS SWAP ABS UM*  R> IF DNEGATE THEN ;;
:: */MOD ( n n n -- r q ) >R M* R> M/MOD -;'
:: */ ( n n n -- q ) */MOD SWAP DROP ;;

CRR .( Bits & Bytes ) CRR
:: >CHAR ( c -- c )
  $7F LIT AND DUP $7F LIT BL WITHIN
  IF DROP ( CHAR _ ) $5F LIT THEN ;;

CRR .( Memory access ) CRR
:: HERE ( -- a ) CP @ ;;
:: PAD ( -- a ) CP @ 50 LIT + ;;
:: TIB ( -- a ) 'TIB @ ;;

CRR
:: @EXECUTE ( a -- ) @ ?DUP IF EXECUTE THEN ;;
:: CMOVE ( b b u -- )
  FOR AFT >R DUP @ R@ ! 1+ R> 1+ THEN NEXT 2DROP ;;
:: FILL ( b u c -- )
  SWAP FOR SWAP AFT 2DUP ! 1+ THEN NEXT 2DROP ;;
:: PACK$ ( b u a -- a ) \ null fill
  dup push
  1 ldi tmp sta st
  sta dup push st
  lda pop
  FOR AFT ( b a )
    B>
    tmp sta ld
    IF ld 1 ldi xor
      IF dup dup xor st
         1 ldi add
      ELSE 2 ldi st
      THEN
    ELSE 1 ldi st
    THEN
  THEN NEXT
  tmp sta ld 
  IF ld 2 ldi xor
     IF sta ld
        shl shl shl shl
        shl shl shl shl
        st lda
     THEN
     sta ld
     shl shl shl shl
     shl shl shl shl
     st lda
  THEN
  drop drop pop
  ;;
:: UNPACK$ ( a b -- b )
  DUP >R ( save b )
  >B $1F LIT AND 3 LIT /
  FOR AFT
    >B DROP
  THEN NEXT
  2DROP R>
  ;;

CRR .( Numeric Output ) CRR \ single precision
:: DIGIT ( u -- c )
  9 LIT OVER < 7 LIT AND +
  ( CHAR 0 ) 30 LIT + ;;
:: EXTRACT ( n base -- n c )
  0 LIT SWAP UM/MOD SWAP DIGIT -;'
:: <# ( -- ) PAD HLD ! ;;
:: HOLD ( c -- ) HLD @ 1- DUP HLD ! ! ;;
:: # ( u -- u ) BASE @ EXTRACT HOLD -;'
:: #S ( u -- 0 ) BEGIN # DUP WHILE REPEAT ;;
CRR
:: SIGN ( n -- ) 0< IF ( CHAR - ) 2D LIT HOLD THEN ;;
:: #> ( w -- b u ) DROP HLD @ PAD OVER - ;;
:: str ( n -- b u ) DUP >R ABS <# #S R> SIGN #> -;'
:: HEX ( -- ) 10 LIT BASE ! ;;
:: DECIMAL ( -- ) 0A LIT BASE ! ;;

CRR .( Numeric Input ) CRR \ single precision
:: DIGIT? ( c base -- u t )
  >R ( CHAR 0 ) 30 LIT - 9 LIT OVER <
  IF 7 LIT - DUP 0A LIT  < OR THEN DUP R> U< -;'
:: NUMBER? ( a -- n T | a F )
  BASE @ >R  0 LIT OVER COUNT ( a 0 b n)
  OVER @ ( CHAR $ ) 24 LIT =
  IF HEX SWAP 1+ SWAP 1- THEN ( a 0 b' n')
  OVER @ ( CHAR - ) 2D LIT = >R ( a 0 b n)
  SWAP R@ - SWAP R@ + ( a 0 b" n") ?DUP
  IF 1- ( a 0 b n)
    FOR DUP >R @ BASE @ DIGIT?
      WHILE SWAP BASE @ * +  R> 1+
    NEXT DROP R@ ( b ?sign) IF NEGATE THEN SWAP
      ELSE R> R> ( b index) 2DROP ( digit number) 2DROP 0 LIT
      THEN DUP
  THEN R> ( n ?sign) 2DROP R> BASE ! ;;

CRR .( Basic I/O ) CRR
:: SPACE ( -- ) BL EMIT -;'
:: CHARS ( +n c -- )
  SWAP 0 LIT MAX
  FOR AFT DUP EMIT THEN NEXT DROP ;;
:: SPACES ( +n -- ) BL CHARS -;'
:: TYPE ( b u -- )
  FOR AFT DUP @ >CHAR EMIT 1+
  THEN NEXT DROP ;;
:: CR ( -- ) ( =Cr )
  0A LIT 0D LIT EMIT EMIT -;'
:: do$ ( -- a )
  R> R@ TEXT UNPACK$
  R@ R> @ $3FFFFF LIT AND $30000 LIT / 1+ +
  >R SWAP >R ;;

CRR
:: $"| ( -- a ) do$ -;' 
:: ."| ( -- ) do$ COUNT TYPE -;'
::  .R ( n +n -- )
  >R str      R> OVER - SPACES TYPE -;'
:: U.R ( u +n -- )
  >R <# #S #> R> OVER - SPACES TYPE -;'
:: U. ( u -- ) <# #S #> SPACE TYPE -;'
::  . ( n -- )
  BASE @ 0A LIT  XOR
  IF U. EXIT THEN str SPACE TYPE -;'
:: ? ( a -- ) @ . -;'

CRR .( Parsing ) CRR
:: (parse) ( b u c -- b u delta ; <string> )
  tmp ! OVER >R DUP \ b u u
  IF 1- tmp @ BL =
    IF              \ b u' \ 'skip'
      FOR BL OVER @ - 0< NOT
        WHILE 1+
      NEXT ( b) R> DROP 0 LIT DUP EXIT \ all delim
        THEN  R>
    THEN OVER SWAP  \ b' b' u' \ 'scan'
    FOR tmp @ OVER @ -  tmp @ BL =
      IF 0< THEN WHILE 1+
    NEXT DUP >R
      ELSE R> DROP DUP 1+ >R
      THEN OVER -  R>  R> - EXIT
  THEN ( b u) OVER R> - ;;
:: PARSE ( c -- b u ; <string> )
  >R  TIB >IN @ +
  #TIB @ >IN @ -
  R> (parse) >IN +! ;;
:: TOKEN ( -- a ;; <string> )
  BL PARSE 1F LIT MIN 2DUP
  DUP TEXT ! TEXT 1+ SWAP CMOVE
  HERE 1+ PACK$ -;'
:: WORD ( c -- a ; <string> )
  PARSE HERE 1+ PACK$ -;'

CRR .( Dictionary Search ) CRR
:: NAME> ( a -- xt )
  DUP @ $3FFFFF LIT AND
  $30000 LIT / + 1+ ;;
:: SAME? ( a a u -- a a f \ -0+ )
  $30000 LIT /
  FOR AFT OVER R@ + @
    OVER R@ + @ - ?DUP
    IF R> DROP EXIT THEN
  THEN NEXT
  0 LIT ;;
:: find ( a va -- xt na | a F )
  SWAP         \ va a
  DUP @ tmp !  \ va a  \ get cell count
  DUP @ >R     \ va a  \ count
  1+ SWAP      \ a' va
  BEGIN @ DUP  \ a' na na
    IF DUP @ $3FFFFF LIT AND
      R@ XOR \ ignore lexicon bits
      IF 1+ -1 LIT
      ELSE 1+ tmp @ SAME?
      THEN
    ELSE R> DROP SWAP 1- SWAP EXIT \ a F
    THEN
  WHILE 1- 1-  \ a' la
  REPEAT R> DROP SWAP DROP
  1- DUP NAME> SWAP ;;
:: NAME? ( a -- xt na | a F )
  CONTEXT find -;'

CRR .( Terminal ) CRR
:: ^H ( b b b -- b b b ) \ backspace
  >R OVER R> SWAP OVER XOR
  IF ( =BkSp ) 8 LIT EMIT
     1-         BL EMIT \ distructive
     ( =BkSp ) 8 LIT EMIT \ backspace
  THEN ;;
:: TAP ( bot eot cur c -- bot eot cur )
  DUP EMIT OVER ! 1+ ;;
:: kTAP ( bot eot cur c -- bot eot cur )
  DUP ( =Cr ) 0D LIT XOR
  IF ( =BkSp ) 8 LIT XOR
    IF BL TAP ELSE ^H THEN
    EXIT
  THEN DROP SWAP DROP DUP ;;

CRR
:: accept ( b u -- b u )
  OVER + OVER
  BEGIN 2DUP XOR
  WHILE  KEY  DUP BL -  5F LIT U<
    IF TAP ELSE kTAP THEN
  REPEAT DROP  OVER - ;;
:: EXPECT ( b u -- ) accept SPAN ! DROP ;;
:: QUERY ( -- )
  TIB 50 LIT accept #TIB !
  DROP 0 LIT >IN ! ;;

CRR .( Error handling ) CRR
:: ABORT ( -- ) 'ABORT @EXECUTE ;;
:: abort" ( f -- )
  IF do$ COUNT TYPE ABORT THEN do$ DROP ;;

CRR .( Interpret ) CRR
:: ERROR ( a -- )
  SPACE TEXT COUNT TYPE
  $3F LIT EMIT CR ABORT
:: $INTERPRET ( a -- )
  NAME?  ?DUP
  IF @ 400000 LIT AND
    ABORT" $LIT compile only" EXECUTE EXIT
  THEN DROP TEXT NUMBER?
  IF EXIT THEN ERROR
:: [ ( -- )
  forth' $INTERPRET  >body forth@ LIT 'EVAL !
  ;; IMMEDIATE
:: .OK ( -- )
  forth' $INTERPRET >body forth@ LIT 'EVAL @ =
  IF ."| $LIT  OK" CR
  THEN ;;
:: EVAL ( -- )
  BEGIN TOKEN DUP @
  WHILE 'EVAL @EXECUTE \ ?STACK
  REPEAT DROP .OK -;'

CRR .( Shell ) CRR
:: QUIT ( -- )
  ( =TIB) $730 LIT 'TIB !
   [ BEGIN QUERY EVAL AGAIN

CRR .( Compiler Primitives ) CRR
:: ' ( -- xt )
  TOKEN NAME? IF EXIT THEN
  ERROR
:: ALLOT ( n -- ) CP +! ;;
:: , ( w -- ) HERE DUP 1+ CP ! ! ;;
:: [COMPILE] ( -- ; <string> )
  '  $100000 LIT OR , -;' IMMEDIATE

CRR
:: COMPILE ( -- ) R> DUP @ , 1+ >R ;;
:: LITERAL $29E79E LIT , ,
  -;' IMMEDIATE
:: $," ( -- ) ( CHAR " )
  22 LIT WORD @ 1+ ALLOT -;'

CRR .( Name Compiler ) CRR
:: ?UNIQUE ( a -- a )
  DUP NAME?
  IF TEXT COUNT TYPE ."| $LIT  reDef "
  THEN DROP ;;
:: $,n ( a -- )
  DUP @
  IF ?UNIQUE
    ( na) DUP DUP NAME> CP !
    ( na) DUP LAST ! \ for OVERT
    ( na) 1-
    ( la) CONTEXT @ SWAP ! EXIT
  THEN ERROR

CRR .( FORTH Compiler ) CRR

:: $COMPILE ( a -- )
  NAME? ?DUP
  IF @ $800000 LIT AND
    IF EXECUTE
    ELSE $3FFFF LIT AND $100000 LIT OR ,
    THEN EXIT
  THEN DROP TEXT NUMBER?
  IF LITERAL EXIT
  THEN ERROR
:: OVERT ( -- ) LAST @ CONTEXT ! ;;
:: ; ( -- )
  $5E79E LIT , [ OVERT -;' IMMEDIATE
:: ] ( -- )
  forth' $COMPILE >body forth@ LIT 'EVAL ! ;;
:: : ( -- ; <string> )
  TOKEN $,n ] -;'

CRR .( Tools ) CRR
:: dm+ ( b u -- b )
  OVER 7 LIT U.R SPACE
  FOR AFT DUP @ 7 LIT U.R 1+
  THEN NEXT ;;
:: DUMP ( b u -- )
  BASE @ >R HEX  8 LIT /
  FOR AFT CR 8 LIT 2DUP dm+
  THEN NEXT DROP R> BASE ! ;;

CRR
:: >NAME ( xt -- na | F )
  CONTEXT
  BEGIN @ DUP
  WHILE 2DUP NAME> XOR
    IF 1-
    ELSE SWAP DROP EXIT
    THEN
  REPEAT SWAP DROP ;;
:: .ID ( a -- )
  TEXT UNPACK$
  COUNT $01F LIT AND TYPE SPACE -;'

CRR
:: SEE ( -- ; <string> )
  ' CR
  BEGIN
    20 LIT FOR
      DUP @ DUP FC0000 LIT AND
      DUP
      IF 100000 LIT XOR THEN
      IF U. SPACE
      ELSE 3FFFF LIT AND >NAME
        ?DUP IF .ID THEN
      THEN 1+
    NEXT KEY 0D LIT =  \ can't use ESC on terminal
  UNTIL DROP ;;
:: WORDS ( -- )
  CR CONTEXT
  BEGIN @ ?DUP
  WHILE DUP SPACE .ID 1-
  REPEAT ;;
CODE .S ( dump all 17 stack items )
  PAD sta stp
  stp stp stp stp
  stp stp stp stp
  stp stp stp stp
  stp stp stp stp
  DROP PAD $10 LIT
  FOR DUP ? 1+ NEXT
  DROP PAD @ CR -;'

CRR .( Hardware reset ) CRR
::   DIAGNOSE     ( - )
     $65 LIT
\ 'F'  prove UM+ 0<         \ carry, TRUE, FALSE
     0 LIT 0< -2 LIT 0<     \ 0 FFFF
     UM+ DROP               \ FFFF ( -1)
     3 LIT UM+ UM+ DROP     \ 3
     $43 LIT UM+ DROP       \ 'F'
\ 'o' logic: XOR AND OR
     $4F LIT $6F LIT XOR    \ 20h
     $F0 LIT AND
     $4F LIT OR
\ 'r' stack: DUP OVER SWAP DROP
      8 LIT 6 LIT SWAP
      OVER XOR 3 LIT AND AND
      $70 LIT UM+ DROP       \ 'r'
\ 't'-- prove BRANCH ?BRANCH
      0 LIT IF $3F LIT THEN
      -1 LIT IF $74 LIT ELSE $21 LIT THEN
\ 'h' -- @ ! test memeory address
      $68 LIT $700 LIT !
      $700 LIT @
\ 'M' -- prove >R R> R@
      $4D LIT >R R@ R> AND
\ 'l'  -- prove 'next' can run
      1 LIT $6A LIT FOR 1 LIT UM+ DROP NEXT
      ;;

CRR
:: COLD ( -- )
   diagnose
   CR ."| $LIT P24 v"
   66 LIT <# # # ( CHAR . ) 2E LIT HOLD # #> TYPE
   CR QUIT

CRR .( Structures ) CRR
:: IF ( -- A )    HERE $80000 LIT , -;' IMMEDIATE
:: FOR ( -- a )   $71E79E LIT , HERE -;' IMMEDIATE
:: BEGIN ( -- a ) HERE -;' IMMEDIATE
:: AHEAD ( -- A ) HERE 0 LIT , -;' IMMEDIATE
CRR
:: AGAIN ( a -- ) , -;' IMMEDIATE
:: THEN ( A -- )  HERE SWAP +! ;; IMMEDIATE
:: NEXT ( a -- )  COMPILE doNEXT , -;' IMMEDIATE
:: UNTIL ( a -- ) $80000 LIT + , -;' IMMEDIATE
CRR
:: REPEAT ( A a -- ) AGAIN THEN -;' IMMEDIATE
:: AFT ( a -- a A )  DROP AHEAD BEGIN SWAP ;; IMMEDIATE
:: ELSE ( A -- A )   AHEAD SWAP THEN -;' IMMEDIATE
:: WHILE ( a -- A a ) IF SWAP ;; IMMEDIATE

CRR .( macro words ) CRR

CODE EXIT pop drop ret
CODE EXECUTE push ret
CODE ! sta st ret
CODE @ sta ld ret

CRR
CODE R> pop sta pop lda push ret
CODE R@ pop sta pop dup push lda push ret
CODE >R sta pop push lda ret

CRR
CODE SWAP
   push sta pop lda ret
CODE OVER
   push dup sta pop
   lda ret
CODE 2DROP
   drop drop ret

CRR
CODE +  add ret
CODE NOT com ret
CODE  NEGATE
   com 1 ldi add ret
CODE 1-
   -1 ldi add ret
CODE 1+
   1 ldi add ret

CRR
CODE BL
   20 ldi ret
CODE +!
   sta ld add st
   ret
CODE -
   com add 1 ldi add
   ret

CRR
CODE DUP dup ret
CODE DROP drop ret
CODE AND and ret
CODE XOR xor ret
CODE COM com ret

CRR
:: ABORT" ( -- ; <string> ) COMPILE abort" $," ;; IMMEDIATE
:: $" ( -- ; <string> ) COMPILE $"| $," ;; IMMEDIATE
:: ." ( -- ; <string> ) COMPILE ."| $," ;; IMMEDIATE
:: CODE ( -- ; <string> ) TOKEN $,n OVERT -;'
:: CREATE ( -- ; <string> ) CODE doVAR ;;
:: VARIABLE ( -- ; <string> ) CREATE 0 LIT , -;'

CRR
:: .( ( -- ) 29 LIT PARSE TYPE -;' IMMEDIATE
:: \ ( -- ) #TIB @ >IN ! ;; IMMEDIATE
:: ( 29 LIT PARSE 2DROP ;; IMMEDIATE
:: IMMEDIATE $800000 LIT LAST @ @ OR LAST @ ! ;;

CRR

